<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>
        /** Define the margins of your page **/
        @page  {
            size: 21cm 29.7cm;
            margin: 0;

        }

        .pagenum:before {
            content: counter(page);
        }

        body {
            font-family: helvetica !important;
            font-size: 12px;
            position: relative;
            margin-top: 3cm;
            margin-left: 2cm;
            margin-right: 2cm;
            margin-bottom: 3cm;
        }

        table tr td {
            font-size: 12px;
        }

        p {
            line-height: 12px;
        }

        #watermark {
            position: fixed;
            bottom: 0;
            left: 0;
            top: 0;
            right: 0;
            width: 21cm;
            height: 29.7cm;
            z-index: -1000;
        }

        footer {
            position: fixed;
            bottom: 0px;
            left: 0px;
            right: 0px;
            height: 80px;
            text-align: center;
            line-height: 8px;
            z-index: 1;
        }

        footer p {
            line-height: 3px;
        }

        .page-break {
            page-break-after: always;
        }

        .text-center {
            text-align: center;
        }

        main {

        }

        .top-info {
            margin-bottom: 2cm;
        }
    </style>
</head>
<body>
<?php
    $btwpre ="BTW-nr: ";
    $pro_nl222 = $declarationObj->pro_nl;
    $imp_be222 = $declarationObj->imp_be;
    $imp_de222 = $declarationObj->imp_de;
    $imp_po222 = $declarationObj->imp_po;
    $imp_turk222 = $declarationObj->imp_turk;
    $import222 = $declarationObj->import;

    $pro_nl22 = str_replace(".",",",$pro_nl222);
    $imp_be22 = str_replace(".",",",$imp_be222);
    $imp_de22 = str_replace(".",",",$imp_de222);
    $imp_po22 = str_replace(".",",",$imp_po222);
    $imp_turk22 = str_replace(".",",",$imp_turk222);
    $import22 = str_replace(".",",",$import222);

    $statement_date = $periodObj->date_statement ? getdate($periodObj->date_statement->timestamp) : null;
    $expiration_date = $periodObj->date_release ? getdate($periodObj->date_release->timestamp) : null;
    $signed_date = $declarationObj->date ? getdate($declarationObj->date->timestamp) : null;

    $aantal_label = 'Aantal gecorrigeerde m2 vlakglas';
    if( $userPeriod->agree_on_creditmemo ){
        $aantal_label = 'Aantal gefactureerde m2 vlakglas';
    }
?>
<footer>
    <p class="text-center">Fonds Vlakglas Recycling Nederland - Postbus 340, 2700 AH Zoetermeer - Tel: 088-5678805</p>
    <p class="text-center">E-mail: info@oavaangifte.nl - BTW nr. 8564.33.779.B.01 - KvK 66188482</p>
    <p style="font-size: 10px">Bladzijde <span class="pagenum"></span></p>
</footer>
<div id="watermark">
    <img src="data:image/png;base64,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"
         height="100%" width="100%"/>
</div>
<main>
    <div class="top-info">
        <table width="100%">
            <tr>
                <td>
                    <?php echo e($user->company_name); ?> <br/>
                    <?php echo e($user->contact_persoon); ?><br/>
                    <?php echo e($user->address); ?> <br/>
                    <?php echo e($user->postcode); ?>, <?php echo e($user->place); ?> <br/>
                    <?php echo e($user->land); ?>

                </td>
                <td align="right">
                    <strong>Bij betaling s.v.p. vermelden</strong><br/>
                    debiteuren-nr / factuur-nr <br/>
                    <?php echo e($user->oav_number); ?> / <?php echo e($file_name_data); ?> <br/>
                    <?php echo e($user->email); ?> <br/>
                    <?php echo e($btwpre); ?> <?php echo e($user->btw_number); ?> <br>
                    <?php if($signed_date): ?>
                        Factuurdatum <?php echo e($signed_date['mday']); ?> <?php echo e(App\Helper\PrintPDF::pickMonth($signed_date['mon'])); ?> <?php echo e($signed_date['year']); ?>

                    <?php endif; ?>
                </td>
            </tr>
        </table>
    </div>

    <div class="block-title">
        <p class="text-center" style="font-size: 16px"><strong>Factuur en opgaveformulier recyclingbijdrage</strong></p>
        <p>Betreft: factuur en opgave formulier inzake het aantal gefactureerde m2 vlakglas op de Nederlandse markt
            gebracht in het tijdvak <?php echo e($periodObj->description); ?></p>
        <ul style="list-style:disc; list-style-position:inside;display:none">
            <li>Opgave dient uiterlijk binnen te zijn
                <?php if($statement_date): ?>
                    op <?php echo e($statement_date['mday']); ?> <?php echo e(\App\Helper\PrintPDF::pickMonth($statement_date['mon'])); ?> <?php echo e($statement_date['year']); ?>

                <?php endif; ?>
            </li>
            <li>De betalingstermijn is 30 dagen
                <?php if($expiration_date): ?>
                    (vervaldatum <?php echo e($expiration_date['mday']); ?> <?php echo e(\App\Helper\PrintPDF::pickMonth($expiration_date['mon'])); ?> <?php echo e($expiration_date['year']); ?>)
                <?php endif; ?>
            </li>
        </ul>
    </div>

    <div class="table">
        <table width="100%">
            <thead>
            <tr>
                <th border="0" style="border:1px solid black;padding: 4px; text-align:left;">Glassoort</th>
                <th border="0" style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($aantal_label); ?></th>
                <th border="0" style="border:1px solid black;padding: 4px; text-align:left;">Gewicht<br>(optioneel)</th>
                <th border="0" style="border:1px solid black;padding: 4px; text-align:left;">Recyclingbijdrage per m2
                </th>
                <th border="0" style="border:1px solid black;padding: 4px; text-align:left;">Bijdrage excl. BTW in
                    euro
                </th>
                <th width="55px" border="0" style="border:1px solid black;padding: 4px; text-align:left;">BTW 21% in euro</th>
                <th border="0" style="border:1px solid black;padding: 4px; text-align:left;">Bijdrage incl. BTW in
                    euro
                </th>
            </tr>
            </thead>
            <tbody>
            <?php
                $sumAantal = 0;
                $sumWeight = 0;
                $sumRecyclingbijdra = 0;
                $sumBijdrage = 0;
                $sumBTW = 0;
                $sumIncl = 0;
                $plus_or_minus_label = '';
            ?>
            <?php
                $total_nl_kg = 0.00;
                $total_be_kg = 0.00;
                $total_de_kg = 0.00;
                $total_po_kg = 0.00;
                $total_turk_kg = 0.00;
                $total_import_kg = 0.00;
            ?>
            <?php $__currentLoopData = $listOfDeclareObject; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $_declare): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $listType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($_declare->declaration_id == $type->id): ?>
                        <?php
                            if(!$_declare->total_m2){
                                $_declare->total_m2 = 0;
                            }
                            if(!$_declare->weight){
                                $_declare->weight = 0;
                            }
                            if(!$_declare->unit_price){
                                $_declare->unit_price = 0;
                            }
                            if(!$_declare->total){
                                $_declare->total = 0;
                            }
                            if(!$_declare->btw){
                                $_declare->btw = 0;
                            }
                            if(!$_declare->total_btw){
                                $_declare->total_btw = 0;
                            }

                            $sumAantal += $_declare->total_m2;
                            $sumWeight += $_declare->weight;
                            $sumRecyclingbijdra += $_declare->unit_price;
                            $sumBijdrage += $_declare->total;
                            $sumBTW += $_declare->btw;
                            $sumIncl += $_declare->total_btw;
                            $fm = $_declare->fm ? json_decode($_declare->fm) : null;
                            if($_declare->plus_or_minus == 'minus'){
                                $plus_or_minus_label = '-';
                            }
                            if($_declare->plus_or_minus == 'plus'){
                                $plus_or_minus_label = '+';
                            }
                        ?>

                        <tr border="0">
                            <td border="0"
                                style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($_declare->type_name); ?>

                                <<?php echo e($_declare->category_name); ?>>
                            </td>
                            <td border="0"
                                style="border:1px solid black;padding: 4px; text-align:left;">
                                <?php echo e($plus_or_minus_label); ?><?php echo e($_declare->total_m2); ?> m2
                            </td>
                            <td border="0"
                                style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($_declare->weight); ?> kg
                            </td>
                            <td border="0" style="border:1px solid black;padding: 4px; text-align:left;">
                                &euro; <?php echo e($_declare->unit_price); ?></td>
                            <td border="0" style="border:1px solid black;padding: 4px; text-align:left;">
                                &euro; <?php echo e($plus_or_minus_label); ?><?php echo e($_declare->total); ?>

                            </td>   
                            <td border="0" style="border:1px solid black;padding: 4px; text-align:left;">
                                &euro; <?php echo e($plus_or_minus_label); ?><?php echo e($_declare->btw); ?>

                            </td>
                            <td border="0" style="border:1px solid black;padding: 4px; text-align:left;">
                                &euro; <?php echo e($plus_or_minus_label); ?><?php echo e($_declare->total_btw); ?>

                            </td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php
            $sumAantal = number_format($sumAantal, 2);
            $sumWeight = number_format($sumWeight, 2);
            $sumRecyclingbijdra = number_format($sumRecyclingbijdra, 2);
            $sumBijdrage = number_format($sumBijdrage, 2);
            $sumBTW = number_format($sumBTW, 2);
            $sumIncl = number_format($sumIncl, 2);

            $sumAantal = str_replace(",", "", $sumAantal);
            $sumWeight = str_replace(",", "", $sumWeight);
            $sumRecyclingbijdra = str_replace(",", "", $sumRecyclingbijdra);
            $sumBijdrage = str_replace(",", "", $sumBijdrage);
            $sumBTW = str_replace(",", "", $sumBTW);
            $sumIncl = str_replace(",", "", $sumIncl);
            ?>
            <tr>
                <td style="border:1px solid black;padding: 4px; text-align:left;">Totaal</td>
                <td style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($plus_or_minus_label); ?><?php echo e($sumAantal); ?> m2</td>
                <td style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($sumWeight); ?> kg</td>
                <td style="border:1px solid black;padding: 4px; text-align:left;"></td>
                <td style="border:1px solid black;padding: 4px; text-align:left;">&euro; <?php echo e($plus_or_minus_label); ?><?php echo e($sumBijdrage); ?></td>
                <td style="border:1px solid black;padding: 4px; text-align:left;">&euro; <?php echo e($plus_or_minus_label); ?><?php echo e($sumBTW); ?></td>
                <td style="border:1px solid black;padding: 4px; text-align:left;">&euro; <?php echo e($plus_or_minus_label); ?><?php echo e($sumIncl); ?></td>
            </tr>
            </tbody>
        </table>
    </div>

    <p>* Optioneel de OAV gebruikt deze gegevens voor haar registratie en worden vertrouwelijk behandeld.</p>
    <p>Deze opgave kan worden uitgesplitst in:</p>
    <div class="table">
        <table width="100%">
            <thead>
            <tr>
                <th style="border:1px solid black;padding: 4px; text-align:left;">Glassoort</th>
                <th style="border:1px solid black;padding: 4px; text-align:left;">Productie in Nederland</th>
                <th style="border:1px solid black;padding: 4px; text-align:left;">Import Duitsland</th>
                <th style="border:1px solid black;padding: 4px; text-align:left;">Import België</th>
                <th style="border:1px solid black;padding: 4px; text-align:left;">Import Polen</th>
                <?php if($year >=2023): ?>
                    <th style="border:1px solid black;padding: 4px; text-align:left;">Import Turkije</th>
                <?php endif; ?>
                <th style="border:1px solid black;padding: 4px; text-align:left;">Import overige</th>
            </tr>
            </thead>
            <tbody>
            <?php
                $total_nl222 = 0.00;
                $total_be = 0.00;
                $total_de = 0.00;
                $total_po = 0.00;
                $total_turk = 0.00;
                $total_import = 0.00;
            ?>
            <?php $__currentLoopData = $listOfDeclareObject; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $_declare): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $listType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($_declare->declaration_id == $type->id): ?>
                        <?php
                            $pro_nl222 = $_declare->pro_nl;
                            $imp_be222 = $_declare->imp_be;
                            $imp_de222 = $_declare->imp_de;
                            $imp_po222 = $_declare->imp_po;
                            $imp_turk222 = $_declare->imp_turk;
                            $import222 = $_declare->import;
                           
                            if(!$pro_nl222){
                                $pro_nl222 = 0;
                            }
                            if(!$imp_be222){
                                $imp_be222 = 0;
                            }
                            if(!$imp_de222){
                                $imp_de222 = 0;
                            }
                            if(!$imp_po222){
                                $imp_po222 = 0;
                            }
                            if(!$imp_turk222){
                                $imp_turk222 = 0;
                            }
                            if(!$import222){
                                $import222 = 0;
                            }


                            $pro_nl_kg222 = $_declare->pro_nl_kg;
                            $imp_be_kg222 = $_declare->imp_be_kg;
                            $imp_de_kg222 = $_declare->imp_de_kg;
                            $imp_po_kg222 = $_declare->imp_po_kg;
                            $imp_turk_kg222 = $_declare->imp_turk_kg;
                            $import_kg222 = $_declare->import_kg;

                            
                            if(!$pro_nl_kg222){
                                $pro_nl_kg222 = 0;
                            }
                            if(!$imp_be_kg222){
                                $imp_be_kg222 = 0;
                            }
                            if(!$imp_de_kg222){
                                $imp_de_kg222 = 0;
                            }
                            if(!$imp_po_kg222){
                                $imp_po_kg222 = 0;
                            }
                            if(!$imp_turk_kg222){
                                $imp_turk_kg222 = 0;
                            }
                            if(!$import_kg222){
                                $import_kg222 = 0;
                            }



                            $total_nl222 += $pro_nl222;
                            $total_be += $imp_be222;
                            $total_de += $imp_de222;
                            $total_po += $imp_po222;
                            $total_turk += $imp_turk222;
                            $total_import += $import222;


                            $total_nl_kg += $pro_nl_kg222;
                            $total_be_kg += $imp_be_kg222;
                            $total_de_kg += $imp_de_kg222;
                            $total_po_kg += $imp_po_kg222;
                            $total_turk_kg += $imp_turk_kg222;
                            $total_import_kg += $import_kg222;


                            $pro_nl22 = str_replace(".",",",$pro_nl222);
                            $imp_be22 = str_replace(".",",",$imp_be222);
                            $imp_de22 = str_replace(".",",",$imp_de222);
                            $imp_po22 = str_replace(".",",",$imp_po222);
                            $imp_turk22 = str_replace(".",",",$imp_turk222);
                            $import22 = str_replace(".",",",$import222);

                            $fm = $_declare->fm ? json_decode($_declare->fm) : null;

                        ?>
                       <tr>
                            <td style="border:1px solid black;padding: 4px; text-align:left;">
                                <?php echo e($_declare->type_name); ?>

                            </td>

                            <td style="border:1px solid black;padding: 4px; text-align:left;">
                                <?php echo e($pro_nl222); ?> m2<br>
                                <small><?php echo e($pro_nl_kg222); ?> kg</small>
                            </td>

                            <td style="border:1px solid black;padding: 4px; text-align:left;">
                                <?php echo e($plus_or_minus_label); ?><?php echo e($imp_de222); ?> m2<br>
                                <small><?php echo e($imp_de_kg222); ?> kg</small>
                            </td>

                            <td style="border:1px solid black;padding: 4px; text-align:left;">
                                <?php echo e($imp_be222); ?> m2<br>
                                <small><?php echo e($imp_be_kg222); ?> kg</small>
                            </td>

                            <td style="border:1px solid black;padding: 4px; text-align:left;">
                                <?php echo e($imp_po222); ?> m2<br>
                                <small><?php echo e($imp_po_kg222); ?> kg</small>
                            </td>

                            <?php if($year >= 2023): ?>
                                <td style="border:1px solid black;padding: 4px; text-align:left;">
                                    <?php echo e($imp_turk222); ?> m2<br>
                                    <small><?php echo e($imp_turk_kg222); ?> kg</small>
                                </td>
                            <?php endif; ?>

                            <td style="border:1px solid black;padding: 4px; text-align:left;">
                                <?php echo e($import222); ?> m2<br>
                                <small><?php echo e($import_kg222); ?> kg</small>
                            </td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php
            $total_nl222 = number_format($total_nl222, 2);
            $total_be = number_format($total_be, 2);
            $total_de = number_format($total_de, 2);
            $total_po = number_format($total_po, 2);
            $total_turk = number_format($total_turk, 2);
            $total_import = number_format($total_import, 2);

            $total_nl_kg = number_format($total_nl_kg, 2);

            $total_be_kg = number_format($total_be_kg, 2);
            $total_de_kg = number_format($total_de_kg, 2);
            $total_po_kg = number_format($total_po_kg, 2);
            $total_turk_kg = number_format($total_turk_kg, 2);
            $total_import_kg = number_format($total_import_kg, 2);

            $total_nl222 = str_replace(",", "", $total_nl222);
            $total_be = str_replace(",", "", $total_be);
            $total_de = str_replace(",", "", $total_de);
            $total_po = str_replace(",", "", $total_po);
            $total_turk = str_replace(",", "", $total_turk);
            $total_import = str_replace(",", "", $total_import);

            $total_be_kg = str_replace(",", "", $total_be_kg);
            $total_de_kg = str_replace(",", "", $total_de_kg);
            $total_po_kg = str_replace(",", "", $total_po_kg);
            $total_turk_kg = str_replace(",", "", $total_turk_kg);
            $total_import_kg = str_replace(",", "", $total_import_kg);
            ?>
            <tr>
                <td style="border:1px solid black;padding: 4px; text-align:left;">Totaal</td>
                <td style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($total_nl222); ?> m2<br><?php echo e($total_nl_kg); ?> kg</td>
                <td style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($plus_or_minus_label); ?><?php echo e($total_de); ?> m2<br><?php echo e($total_de_kg); ?> kg</td>
                <td style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($total_be); ?> m2<br><?php echo e($total_be_kg); ?> kg</td>
                <td style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($total_po); ?> m2<br><?php echo e($total_po_kg); ?> kg</td>
                <?php if($year >=2023): ?>
                    <td style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($total_turk); ?> m2<br><?php echo e($total_turk_kg); ?> kg</td>
                <?php endif; ?>
                <td style="border:1px solid black;padding: 4px; text-align:left;"><?php echo e($total_import); ?> m2<br><?php echo e($total_import_kg); ?> kg</td>
            </tr>
            </tbody>
        </table>
    </div>

    <p></p>
    <br>
   
    <?php
    $text_date = "";
    if (strpos($periodObj->period, "Q1") > 1) {
        $text_date = "30 april";
    }
    if (strpos($periodObj->period, "Q2") > 1) {
        $text_date = "30 juli";
    }
    if (strpos($periodObj->period, "Q3") > 1) {
        $text_date = "30 oktober";
    }
    if (strpos($periodObj->period, "Q4") > 1) {
        $text_date = "30 januari ";
    }
    if (strpos($periodObj->period, "Q5") > 1) {
        $text_date = "30 januari";
    }
    ?>
    <p>Het verschuldigde bedrag voor de recyclingbijdrage (inclusief btw) dient binnen 30 dagen na factuurdatum te worden betaald op bankrekening IBAN: NL10RABO 0322 4366 05 t.n.v. Fonds Vlakglas Recycling Nederland, Zoetermeer.</p>
    <p>Dit formulier hoeft niet verzonden te worden en is voor uw eigen administratie bestemd; u hebt digitaal opgave
        gedaan. Mocht u vragen en/of opmerkingen hebben dan kunt u contact opnemen met de OAV (Onafhankelijke
        Administratie Vlakglas), telefoon 088-5678805</p>
    <br>
    <div>
        <h3>Ondertekening</h3>
        <p>Ik verklaar deze opgave duidelijk, stellig en zonder voorbehoud te hebben ingevuld</p>
        <table width="100%">
            <tr>
                <td>
                    Plaats: <?php echo e($declarationObj->place); ?>

                    <br/>
                    Datum: <?php echo e($signed_date['mday']); ?> <?php echo e(\App\Helper\PrintPDF::pickMonth($signed_date['mon'])); ?> <?php echo e($signed_date['year']); ?>

                </td>
                <td align="right">
                    Telefoon: <?php echo e($declarationObj->phone); ?>

                    <br/>
                    Naam: <?php echo e($declarationObj->name); ?>

                </td>
            </tr>
        </table>
    </div>
</main>

</body>
</html>
<?php /**PATH /Users/thi/Local Sites/oavaangifte/resources/views/dompdf/declaration.blade.php ENDPATH**/ ?>