@extends('layouts.app')

@section('content')
<div id="b-card-body-content" >
    <div class="row">
        <div class="col-12">
            <h1 class="title-page">Uw aangiften</h1>
        </div>
    </div>
    @if(Session::has('b_message'))
        <div class="row mt-3">
            <div class="col-12">
                <div class="alert alert-success">
                    {{ Session::pull('b_message')}}
                </div>
            </div>
        </div>
    @endif
    <div class="row mt-4">
        <div class="col-12">
            <p class="b-font-bolder b-mb-2" style="color: rgb(0,0,139);">Openstaande aangiften</p>
        </div>
        <div class="col-md-8 col-sm-8 col-xs-12">
            <div class="b-adjust-width-table">
                <table class="b-table-show" width="100%">
                    <thead>
                    <tr>
                        <th><p>Tijdvak</p></th>
                        <th><p>omschrijving</p></th>
                        <th><p>type</p></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($listPending as $pending)
                        <tr>
                            <td>{{ $pending->period }}</td>
                            <td>{{ $pending->description }}</td>
                            <td>{{ $listType[$pending->type] }}</td>
                            <td>
                                <a href="{{ route('home.cma', ['id' => $pending->dec_id]) }}">Verwerken Aangifte</a>
                            </td>
                        </tr>
                    @empty
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-12">
            <p class="b-font-bolder b-mb-2" style="color: rgb(0,0,139);">Verwerkte aangiften</p>
        </div>
        <div class="col-md-8 col-sm-8 col-xs-12">
            <div class="b-adjust-width-table">
                <table class="b-table-show" width="100%">
                    <thead>
                    <tr>
                        <th><p>Tijdvak</p></th>
                        <th><p>omschrijving</p></th>
                        <th><p>type</p></th>
                        <th></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php /*foreach($listNon as $_none){ ?>
                        <tr>
                            <td>{{ $_none->period }}</td>
                            <td>{{ $_none->description }}</td>
                            <td>{{ $listType[$_none->type] }}</td>
                            <td>
                                <a href="{{ route('pdf.pdfma', ['id' => $_none->id]) }}">Bekijk factuur</a>
                            </td>
                        </tr>
                    <?php }*/ ?>
                    @forelse($list as $unit)
                        <?php //if(strpos($unit->period,"Q6") === false){ ?>
                        <tr>
                            <td>{{ $unit->period }}</td>
                            <td>{{ $unit->description }}</td>
                            <td>{{ $listType[$unit->type] }}</td>
                            <td>
                                <?php if($unit->agree_on_creditmemo == 0 ){ ?>
                                <a href="{{ route('pdf.pdfma', ['id' => $unit->id]) }}">Bekijk factuur</a>
                                <?php }else{ ?>
                                <?php 
                                    $url_of_file_name =  env('APP_URL').'/storage/pdf/'.$unit->file_pdf_credit_memo_as_gree;
                                ?>
                                <a href="<?php echo $url_of_file_name; ?>">Bekijk factuur</a>
                                <?php } ?>
                            </td>
                            <td>
                                <?php if( $unit->file_ubl_name ):?>
                                    <?php 
                                    $url_of_file_name =  env('APP_URL').'/storage/ubl/'.$unit->file_ubl_name;
                                ?>
                                    <a target="_blank" href="<?php echo $url_of_file_name; ?>">Download UBL </a>
                                <?php endif;?>
                            </td>
                        </tr>
                        <?php //} ?>
                    @empty
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-12">
            <p class="b-font-bolder b-mb-2" style="color: rgb(0,0,139);">OAV certificaten</p>
        </div>
        <div class="col-md-8 col-sm-8 col-xs-12">
            <div class="b-adjust-width-table">
                <table class="b-table-show" width="100%">
                    <thead>
                    <tr>
                        <th><p>Tijdvak</p></th>
                        <th></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                        @forelse($listCert as $cert)
                            <tr>
                                <td>{{ $cert->group_period }}</td>
                                <td>
                                    @if(!empty($cert->next_period))
                                        <a href="{{ route('pdf.printCertification', [
                                            'id' => $cert->group_period,
                                            'next_period' => $cert->next_period
                                        ]) }}">Download certificaat</a>
                                    @else
                                        <span>Geen certificaat beschikbaar</span>
                                    @endif
                                </td>
                                <td>
                                    @if(!empty($cert->next_period))
                                        certificaat is geldig t/m 31 december {{$cert->next_period}}
                                    @else
                                        <span>-</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php $current_date = date("d/m"); ?>
    <?php //if($current_date === "31/12"){ ?>
    <?php if($listOfCreditMemo && $listOfCreditMemo->status == 0){ ?>
    <?php $user_period_id = $listOfCreditMemo->period_id; ?>
    <?php $period_year = $listOfCreditMemo->group_period; ?>
    <div class="row mt-4" >
        <div class="col-12">
            <p class="b-font-bolder b-mb-2" style="color: rgb(0,0,139);">Recyclingbijdrage totaal</p>
        </div>
        <div class="col-md-8 col-sm-8 col-xs-12">
            <div class="b-adjust-width-table">
                <table class="b-table-show" width="100%">
                    <thead>
                    <tr>
                        <th><p>Tijdvak</p></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php echo $listOfCreditMemo->group_period; ?></td>
                            <td>
                                <?php if($listOfCreditMemo->status == 0){ ?>
                                    <a id="text-change"href="{{ route('pdf.total', ['year' => $period_year,'id' => $user_period_id]) }}">Toon nieuwe Recyclingsbijdrage totaal</a>
                                <br/>
                                <?php } ?>
                                <?php if($listOfCreditMemo->status == 1){ ?>
                                    <a id="create_q6" href="{{ route('pdf.q_six', ['id' => $user_period_id, 'year' => $period_year]) }}">Toon Recyclingsbijdrage totaal</a>
                                <?php } ?>
                            </td>
                        </tr>
                        <?php 
                        $textDefaultButton = "Klik hier om te wijzigen";
                        if($listOfCreditMemo->status == 0){
                        ?>
                        <tr style="display: none;">
                            <td><?php echo $listOfCreditMemo->group_period; ?></td>
                            <td>
                               
                                <a id="create_q6" style="display:none" href="{{ route('home.credit.memo', ['id' => $user_period_id, 'year' => $period_year]) }}">Klik hier om te wijzigen</a>
                                <p><input type="radio" name="print-total" id="ja" checked="checked" />Ja, dit ziet er goed uit. Ik ga akkoord.<button id="action-creditmemo">Akkoord</button></p>
                                <p><input type="radio" name="print-total" id="nee"  />Nee, ik wil het graag wijzigen <button id="action-for-nee"><?php echo $textDefaultButton; ?></button></p>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php } ?>
    <div class="row mt-5">
        <div class="col-12">
            <p><a href="/">« Terug </a></p>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    (function($){
        $(document).ready(function(){
            $("#nee").click(function(){
                $("#action-for-nee").html($("#create_q6").html());
            });
            $("#action-creditmemo").click(function(){
                if($("input[name='print-total']:checked").attr("id") === "ja"){
                    //Send email to admin
                    alert("Harteliijk dank!");
                }
            });
            $("#action-for-nee").click(function(){
                top.location.href = $("#create_q6").attr("href");
            });
        });
    })(jQuery);
</script>
@endsection
