@extends('layouts.app')
<style>
    .inline-block {
        display: inline-block;
    }

    .title-block {
        font-size: 13px;
    }
</style>
@section('content')
<form method="post" id="b-card-body-content" novalidate action="{{ route('home.pma') }}">
    <input type="hidden" value="{{ $id }}" name="period_id">
    <input type="hidden" value="{{ $year }}" name="year">
    <input type="hidden" value="{{url()->current()}}" name="_reference">
    @csrf
    <div class="row">
        <div class="col-12">
            <h1 class="title-page">Uw aangiften</h1>
        </div>
    </div>
    <br>
    @if ($errors->any())
    <div class="row mt-3">
        <div class="col-12">
            <div class="alert alert-danger">
                <ul style="margin-bottom: 0">
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
    @endif

    @if(Session::has('b_message'))
    <div class="row mt-3">
        <div class="col-12">
            <div class="alert alert-success">
                {{ Session::pull('b_message')}}
            </div>
        </div>
    </div>
    @endif
    @foreach ($listCategories as $category)
    <h1>{{$category->title}}</h1>
    @forelse($listType as $key => $type)
    @if ($category->id == $type->category_id)
    <?php
    $minimum_validate = $type->minimum_validate;
    $styleDisplay = "display:none";
    $type_id = $type->id;
    $type_name = $type->name;
    //get Q1234 value from this
    //We have 11 attribute for declaration and 5 attribute was disabled. So we will create array contains all value from Q1234
    $arrayValueForAttribute = array(
        "pro_nl" => 0,
        "imp_be" => 0,
        "imp_de" => 0,
        "imp_po" => 0,
        "imp_turk" => 0,
        "import" => 0,
        "weight" => 0,
        "total_m2" => 0,
        "unit_price" => 0,
        "total" => 0,
        "btw" => 0,
        "total_btw" => 0,
    );
    if (isset($list_of_sum_declare[$type_id])) {
        $data_value = $list_of_sum_declare[$type_id];
        $arrayValueForAttribute["pro_nl"] = $data_value["total_pro_nl"];
        $arrayValueForAttribute["imp_be"] = $data_value["total_imp_be"];
        $arrayValueForAttribute["imp_de"] = $data_value["total_imp_de"];
        $arrayValueForAttribute["imp_po"] = $data_value["total_imp_po"];
        $arrayValueForAttribute["imp_turk"] = $data_value["total_imp_turk"];
        $arrayValueForAttribute["import"] = $data_value["total_import"];
        $arrayValueForAttribute["weight"] = $data_value["total_weight"];
        $arrayValueForAttribute["total_m2"] = $data_value["total_m2"];
        $arrayValueForAttribute["unit_price"] = $data_value["total_unit_price"];
        $arrayValueForAttribute["unit_price"] = $type->unit_price;
        $arrayValueForAttribute["total"] = $data_value["total_of_total"];
        $arrayValueForAttribute["btw"] = $data_value["total_btw"];
        $arrayValueForAttribute["total_btw"] = $data_value["total_of_total_btw"];
    }
    ?>
    <div class="row mt-4 d-type-contain"
        data-cat="{{$type->category_id}}"
        data-name="{{$type->name}}"
        data-unit_price="{{$type->unit_price}}">
        <div class="col-12">
            <div class="horizon-line custom-collapse-btn" data-target="#type-{{ $key }}">
                {{ $type_name }}
            </div>
            <input type="hidden" name="dec[{{ $key }}][type_id]" value="{{ $type->id }}">
        </div>
        <div class="col-12 custom-collapse-wrapper" id="type-{{ $key }}"
            style="display: <?= ($key == 0) ? 'block;' : 'none;'; ?>;">
            <div class="row" style="margin-top: 20px">
                <div class="col-md-5 col-12">
                    <p class="b-font-bolder">Heeft u deze periode iets aan te geven?</p>
                </div>
                <div class="col-md-7 col-12">

                    <?php if ($key == 0): ?>
                        <?php if ($PeriodType == 3): ?>
                            <input type="radio" name="dec[{{ $key }}][status]" class="d-status" value="1"> JA
                        <?php endif; ?>
                        <input type="radio" name="dec[{{ $key }}][status]" class="d-status" value="0"
                            style="margin-left: 30px" checked> NEE
                    <?php else: ?>
                        <input type="radio" name="dec[{{ $key }}][status]" class="d-status" value="1"> JA
                        <input type="radio" name="dec[{{ $key }}][status]" class="d-status" value="0"
                            style="margin-left: 30px" checked> NEE
                    <?php endif; ?>

                </div>
            </div>

            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p></p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block title-block">
                        Reeds aangeven
                    </div>
                    <div class="col-4 inline-block title-block">
                        Werkelijk aan te geven over <?php echo $year; ?>
                    </div>
                    <div class="col-3 inline-block title-block">
                        Correctiefactuur
                    </div>
                </div>
            </div>
            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>Productie in Nederland m2</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["pro_nl"]; ?>"
                            class="form-control" data-old="" readonly disabled />
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{$key}}][pro_nl]"
                            class="form-control input-m2 input-change"
                            data-left-value="<?php echo $arrayValueForAttribute["pro_nl"]; ?>"
                            data-sum="sum_port_<?php echo $type_id ?>">
                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>Import uit België m2</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["imp_be"]; ?>"
                            class="form-control" data-old="" readonly disabled />
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{ $key }}][imp_be]"
                            class="form-control input-m2 input-change"
                            data-left-value="<?php echo $arrayValueForAttribute["imp_be"]; ?>"
                            data-sum="sum_port_<?php echo $type_id ?>">
                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>Import uit Duitsland m2</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["imp_de"]; ?>"
                            class="form-control" data-old="" readonly disabled />
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{ $key }}][imp_de]"
                            class="form-control input-m2 input-change"
                            data-left-value="<?php echo $arrayValueForAttribute["imp_de"]; ?>"
                            data-sum="sum_port_<?php echo $type_id ?>">
                    </div>
                    <div class="col-2 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>Import uit Polen m2</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["imp_po"]; ?>"
                            class="form-control" data-old="" readonly disabled />
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{ $key }}][imp_po]"
                            data-left-value="<?php echo $arrayValueForAttribute["imp_po"]; ?>"
                            class="form-control input-m2 input-change"
                            data-sum="sum_port_<?php echo $type_id ?>">
                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
            @if($year >=2023)
            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>Import uit Turkije m2</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["imp_turk"]; ?>"
                            class="form-control" data-old="" readonly disabled />
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{ $key }}][imp_turk]"
                            data-left-value="<?php echo $arrayValueForAttribute["imp_turk"]; ?>"
                            class="form-control input-m2 input-change"
                            data-sum="sum_port_<?php echo $type_id ?>">
                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
            @endif
            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>Import overig m2</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["import"]; ?>"
                            class="form-control" data-old="" readonly disabled />
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{ $key }}][import]"
                            data-left-value="<?php echo $arrayValueForAttribute["import"]; ?>"
                            class="form-control input-m2 input-change"
                            data-sum="sum_port_<?php echo $type_id ?>">
                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
            <div class="row mt-5 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>Totaal aantal gefactureerde m2 isolatieglas</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["total_m2"]; ?>"
                            class="form-control" data-old="" readonly disabled />
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{ $key }}][total_m2]"
                            data-left-value="<?php echo $arrayValueForAttribute["total_m2"]; ?>"
                            class="form-control d-total-m2 input-change" readonly>
                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>Gewicht in kg *</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["weight"]; ?>"
                            class="form-control " readonly disabled>
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{ $key }}][weight]"
                            data-left-value="<?php echo $arrayValueForAttribute["weight"]; ?>"
                            class="form-control weight-input input-change"
                            data-type-id="<?php echo $type_id ?>"
                            data-minimun-validate="<?php echo $minimum_validate; ?>">
                        <input type="hidden" value="<?php echo $minimum_validate; ?>"
                            class="minimun-validate">
                        <p style="color:red;<?php echo $styleDisplay; ?>"
                            id="weight_error_<?php echo $type_id ?>">Weet u zeker dat deze waarde correct
                            is?</p>
                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
            <div class="row mt-4 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>Recyclingbijdrage per m2</p>
                </div>
                <div class="col-12 col-md-8">
                    <!--<input type="text" value="{{ $type->unit_price }}" name="dec[{{ $key }}][unit_price]" class="form-control d-unit-price" readonly>-->
                    <div class="col-4 inline-block">
                        <input type="text" value="{{ $type->unit_price }}"
                            name="dec[{{ $key }}][unit_price]" class="form-control d-unit-price"
                            readonly>
                        <!--<input type="text" value="<?php echo $arrayValueForAttribute["unit_price"]; ?>" class="form-control " readonly disabled>-->
                    </div>
                    <div class="col-4 inline-block">
                        <!--input type="text" value="<?php echo $arrayValueForAttribute["unit_price"]; ?>"  name="dec[{{ $key }}][unit_price]" data-left-value="<?php echo $arrayValueForAttribute["unit_price"]; ?>" class="form-control d-unit-price input-change" readonly-->

                        <input type="text" value="{{ $type->unit_price }}"
                            name="dec[{{ $key }}][unit_price]"
                            data-left-value="{{ $type->unit_price }}"
                            class="form-control d-unit-price input-change" readonly>
                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>Bijdrage excl. BTW in Euro</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["total"]; ?>"
                            class="form-control " readonly disabled>
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{ $key }}][total]"
                            data-left-value="<?php echo $arrayValueForAttribute["total"]; ?>"
                            class="form-control d-total input-change" readonly>
                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>BTW 21%</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["btw"]; ?>"
                            class="form-control " readonly disabled>
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{ $key }}][btw]"
                            data-left-value="<?php echo $arrayValueForAttribute["btw"]; ?>"
                            class="form-control d-btw input-change"
                            @if($user->land != "NL") data-btw="0" @else data-btw="21"
                        @endif readonly>


                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>

            <div class="row mt-2 b-show-hide">
                <div class="col-12 col-md-4">
                    <p>bijdrage inclusief BTW in Euro</p>
                </div>
                <div class="col-12 col-md-8">
                    <div class="col-4 inline-block">
                        <input type="text" value="<?php echo $arrayValueForAttribute["total_btw"]; ?>"
                            class="form-control " readonly disabled>
                    </div>
                    <div class="col-4 inline-block">
                        <input type="text" value="" name="dec[{{ $key }}][total_btw]"
                            data-left-value="<?php echo $arrayValueForAttribute["total_btw"]; ?>"
                            class="form-control d-total-btw input-change" readonly>
                    </div>
                    <div class="col-3 inline-block">
                        <span class="detal-changed" data-parent=""></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    @empty
    @endforelse
    <br>
    @endforeach
    <div class="row mt-5">
        <div class="col-12">
            <p class="b-font-bolder">Ondertekening</p>
        </div>
        <div class="col-12">
            <p class="b-font-bolder">Ik verklaar deze opgave duidelijk, stellig en zonder voorbehoud te hebben
                ingevuld.</p>
        </div>
    </div>
    <div class="row">
        <div class="col-12 col-md-5">
            <p>Plaats</p>
        </div>
        <div class="col-12 col-md-5">
            <input type="text" name="place" class="form-control" value="{{ old('place', $user->place) }}">
        </div>
    </div>
    <div class="row mt-2">
        <div class="col-12 col-md-5">
            <p>Naam</p>
        </div>
        <div class="col-12 col-md-5">
            <input type="text" name="name" class="form-control" value="{{ old('name') }}" />
        </div>
    </div>
    <div class="row mt-2">
        <div class="col-12 col-md-5">
            <p>Telefoon</p>
        </div>
        <div class="col-12 col-md-5">
            <input type="text" name="phone" class="form-control" value="{{ old('phone',$user->phone) }}" />
        </div>
    </div>
    <div class="row mt-2">
        <div class="col-12 col-md-5">
            <p>Uw wachtwoord</p>
        </div>
        <div class="col-12 col-md-5">
            <input type="password" name="password" class="form-control" />
        </div>
    </div>
    <br>
    <div class="row a-mt-15">
        <div class="col-xs-12 col-md-5"></div>
        <div class="col-xs-12 col-md-5">
            <button type="submit" value="submit" name="mode" class="btn btn-primary btn-sm"
                onclick="var e=this;setTimeout(function(){e.disabled=true;},0);return true;">Bevestigen
            </button>
            <!--<button type="submit" value="save" name="mode" class="btn btn-warning btn-sm">Opslaan</button>-->
        </div>
    </div>
    <br>
    <br>
</form>
@endsection

@section('js')
<script src="{{ asset('/js/cma.js') }}"></script>
<script>
    (function($) {
        $(document).ready(function() {
            jQuery('.custom-collapse-btn').on('click', function() {
                var target = jQuery(this).data('target');
                jQuery(target).toggle();
            });
            //var dTypeContainFirst = $(".d-type-contain").first();
            //dTypeContainFirst.find(".horizon-line").removeClass('collapsed');
            //dTypeContainFirst.find(".collapse").addClass('show');
        });

        function addCommas(nStr) {
            nStr += '';
            var x = nStr.split(',');
            var x1 = x[0];
            var x2 = x.length > 1 ? ',' + x[1] : '';
            var rgx = /(\d+)(\d{3})/;
            while (rgx.test(x1)) {
                x1 = x1.replace(rgx, '$1' + '.' + '$2');
            }
            return x1 + x2;
        }

        $.fn.digits = function() {
            return this.each(function() {
                console.log(this);
                $(this).text($(this).text().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1."));
            })
        };
        $(".input-m2").keyup(function() {
            //var value = addCommas($(this).val());
            //$(this).val(value);
        });
        $(".weight-input").change(function() {
            var elem = $(this);
            var value_of_elem = elem.val();
            var type_id = elem.attr("data-type-id");
            var data_minimun_validate = parseFloat(elem.attr("data-minimun-validate"));
            var sum_id = "sum_port_" + type_id;
            var list_of_import = $("input[data-sum='" + sum_id + "']");
            var lengthOfList = list_of_import.length;
            var sumImport = 0.0;
            for (var i = 0; i < lengthOfList; i++) {
                sumImport += parseFloat(list_of_import[i].value);
            }
            var threadSold = data_minimun_validate * sumImport;
            if (value_of_elem < threadSold) {
                //Show warning in here
                elem.attr("style", "border:1px #ced4da solid;box-shadow: 0 0 0 0.2rem rgba(220, 52, 52);");
                $("#weight_error_" + type_id).show();
            } else {
                $("#weight_error_" + type_id).hide();
                elem.attr("style", "border:1px solid #ced4da;");
            }
        });
        /* new code */
        $(".input-m2").blur(function() {
            let _parent = $(this).closest('.d-type-contain');
            let _total_m2 = 0;
            let _price = Number(_parent.find('.d-unit-price').val());
            let _minimumValidate = Number(_parent.find(".minimun-validate").val());
            _parent.find('.input-m2').each(function() {
                let valOfInput = $(this).val().replace(",", ".");
                _total_m2 += Number(valOfInput);
            });
            let _threadSold = _total_m2 * _minimumValidate;
            _parent.find('.d-total-m2').val(_total_m2.toFixed(2));
            _calc(_parent, _total_m2, _price);
        })


        let _calc = function(obj, _total_m2, _price) {
            let _total = Number(_price * _total_m2);
            let _btw = Number(_total * obj.find('.d-btw').attr('data-btw') / 100);
            let _total_btw = Number(_total) + Number(_btw);

            // console.log( _total );
            // console.log( _btw );
            // console.log( _total_btw );


            obj.find('.d-total').val(_total.toFixed(2));
            obj.find('.d-btw').val(_btw.toFixed(2));
            obj.find('.d-total-btw').val(_total_btw.toFixed(2));

            obj.find('.d-total-m2').change();
            obj.find('.d-total').change();
            obj.find('.d-btw').change();
            obj.find('.d-total-btw').change();
        }

        /* end new code */
        jQuery('body').on('change', '.input-change', function() {
            console.log('change');
            var elem = $(this);
            var left_value = elem.attr("data-left-value");
            var current_value = elem.val();
            var numberDelta = parseFloat(current_value ? current_value : 0) - parseFloat(left_value ? left_value : 0);
            numberDelta = numberDelta.toFixed(2);
            var delta = numberDelta > 0 ? '+' + numberDelta : numberDelta;
            console.log(numberDelta);
            console.log(delta);
            /*if(left_value > current_value){
                var numberDelta = left_value - current_value;
                delta += "-".numberDelta;
            }
            if(left_value < current_value){
                var numberDelta = left_value - current_value;
                delta += "+".numberDelta;
            }*/
            var parentWrapper = elem.parent().parent();
            parentWrapper.find(".detal-changed").html(delta);
        });
    })(jQuery);
</script>
@endsection