@extends('layouts.color_admin.default')
@section('title', 'Period')
@section('content')
    <div class="a-page-content">
        <div class="breadcomb-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="breadcomb-list">
                            <form method="post" action="{{ route('admin.period.savePeriod') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-12" style="padding-left: 30px">
                                        <h3>
                                            Update Period (
                                            {{ !empty($period->date_start) ? $period->date_start->format('Y-m-d') : "" }}
                                            {{ " to " }}
                                            {{ !empty($period->date_end) ? $period->date_end->format('Y-m-d') : "" }})
                                        </h3>
                                    </div>
                                </div>

                                @if ($errors->any())
                                    <div class="row mt-3 mb-3">
                                        <div class="col-12">
                                            <div class="alert alert-danger">
                                                <ul style="margin-bottom: 0">
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                <input type="hidden" name="id" value="{{ $period->id }}">
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Period</span>
                                    </div>
                                    <div class="col-12 col-md-4 a-mt-15">
                                        <input type="text" class="form-control" name="period" value="{{ old('period', $period->period) }}" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Beschrijving</span>
                                    </div>
                                    <div class="col-12 col-md-4  a-mt-15">
                                        <input type="text" class="form-control" name="description" value="{{ old('description', $period->description) }}" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Date statement</span>
                                    </div>
                                    <div class="col-12 col-md-4  a-mt-15">
                                        <input type="text" class="form-control input-date" name="date_statement" value="{{ old('date_statement', $period->date_statement->format('d-m-Y')) }}" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Date release</span>
                                    </div>
                                    <div class="col-12 col-md-4  a-mt-15">
                                        <input type="text" class="form-control input-date" name="date_release" value="{{ old('date_release', $period->date_release->format('d-m-Y')) }}" required>
                                    </div>
                                </div>
                                <div class="row a-mt-45">
                                    <div class="col-md-2 col-12 text-center"></div>
                                    <div class="col-md-4 text-right col-12">
                                        <button class="btn btn-primary btn-sm">Opslaan</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(function () {
            var pathname = window.location.pathname;
            var menuItem = $('a[href="/admin/periodList"]').closest('li');
			menuItem.addClass('active');
            menuItem.closest('li.has-sub').addClass('active');

            let _page = $('.a-page-content');
            $('.input-date').datepicker({ dateFormat: 'dd-mm-yy' });
        })
    </script>
@endpush

