@extends('layouts.color_admin.default')
@section('title', 'Periodes')
@push('css')
<link href="https://nightly.datatables.net/select/css/select.dataTables.css?_=766c9ac11eda67c01f759bab53b4774d.css" rel="stylesheet" type="text/css" />
@endpush
@section('content')
<div class="a-page-content">
    <div class="normal-table-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="normal-table-list">
                        <div class="basic-tb-hd a-header-content">
                            <h2>Periodes</h2>
                            <p>Totaal: {{ $list->total() }}</p>
                        </div>

                        @if(Session::has('b_a_message'))
                        <div class="row mt-3 mb-4">
                            <div class="col-12">
                                <div class="alert alert-success">
                                    {{ Session::pull('b_a_message')}}
                                </div>
                            </div>
                        </div>
                        @endif

                        <div class="bsc-tbl">
                            <table class="table-periods table table-sc-ex">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>periode</th>
                                        <th>Omschrijving</th>
                                        <th>Type</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($list as $key => $item)
                                    <tr>
                                        <td>{{ ($list->currentPage() - 1) * config('appvalue.paging') + $key + 1 }}</td>
                                        <td>{{ $item->period }}</td>
                                        <td>{{ $item->description }}</td>
                                        <td>{{ $listPeriodType[$item->type] }}</td>
                                        <td>
                                            <a href="{{ route('admin.period.emailPeriod', ['id' => $item->id]) }}" class="btn btn-sm btn-primary">Herinneringsmail</a>
                                            <button periodId="{{$item->id}}" type="button" data-toggle="modal" data-target="#modalAssignUser" class="bt-modal-assign btn btn-warning btn-sm">Gebruiker koppelen aan periode</button>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="text-center">Geen informatie.</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-5">
                <div class="col-12">
                    <div style="padding-left: 15px">
                        {{ $list->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal assign users -->
<div class="modal fade" id="modalAssignUser" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-xdev modal-dialog-centered" role="document">
        <div class="modal-content xdev-table">
            <form id="formAssign" action="{{ route('admin.period.sendPeriod') }}" method="post">
                @csrf
                <input type="hidden" id="id" name="id" value="">
                <input type="hidden" id="user_id" name="user_id" value="">
                <input type="hidden" id="email" name="email" value="">
                <div class="modal-header">
                    <h5 class="modal-title text-uppercase" id="exampleModalLongTitle">Koppel gebruikers aan deze periode</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table id="data-table-users" class="table table-sc-ex">
                        <thead>
                            <tr>
                                <th class="hidden"></th>
                                <th>#</th>
                                <th>Gebruikersnaam</th>
                                <th>Eind datum</th>
                                <th>OAV nummer</th>
                                <th>Bedrijfsnaam</th>
                                <th>E-mail</th>
                                <th>Adres</th>
                                <th>
                                    <label class="checkbox-inline">
                                        <input class="check-all" type="checkbox" value="">
                                    </label>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuleren</button>
                    <button type="submit" value="4" name="mode" class="btn btn-primary">Verzend e-mail</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')

<script src="/admin_asset/plugins/datatables/js/select/dataTables.select.js"></script>
<script src="/admin_asset/js/select2.min.js"></script>
<script>
    $(function() {
        var modalAssignUser = $("#modalAssignUser");

        var dataTableUser = $("#data-table-users").DataTable({
            'paging': true,
            "pagingType": "simple_numbers",
            'lengthChange': true,
            'searching': true,
            'info': true,
            'autoWidth': false,
            'stateSave': true,
            'columnDefs': [{
                orderable: false,
                className: 'select-checkbox',
                targets: 8
            }],
            'select': {
                style: 'multi',
                selector: 'td:last-child'
            }
        });

        dataTableUser.on('select deselect', function() {
            getDataRows();
        });

        $(".check-all").on("click", function() {
            if ($(this).is(":checked")) {
                dataTableUser.rows().select();
            } else {
                dataTableUser.rows().deselect();
            }
            getDataRows();
        });

        var getDataRows = function() {
            var data = dataTableUser.rows({ selected: true }).data();
            if (data.length === 0) {
                modalAssignUser.find("#email").val('');
                modalAssignUser.find("#user_id").val('');
                return;
            }
            var userIdArray = [];
            var emailArray = [];
            for (var i = 0; i < data.length; i++) {
                userIdArray.push(data[i][0]);     // hidden user_id
                emailArray.push(data[i][6]);      // kolom 6 = e-mail
            }
            modalAssignUser.find("#email").val(emailArray.join());
            modalAssignUser.find("#user_id").val(userIdArray.join());
        };

        $(".bt-modal-assign").on("click", function() {
            var periodId = $(this).attr('periodId');
            modalAssignUser.find('#id').val(periodId);

            $.ajax({
                type: "GET",
                dataType: "json",
                url: '{{route("admin.home.getListUserForAssignToPeriod")}}',
                data: { 'period_id': periodId },
                success: function(data) {
                    if (data) {
                        var tbody = $("#data-table-users").find('tbody');
                        var rowItem = '';
                        $.each(data, function(i, item) {
                            rowItem += '<tr>';
                            rowItem += '<td class="hidden">' + item.id + '</td>';
                            rowItem += '<td>' + (i+1) + '</td>';
                            rowItem += '<td>' + item.user_name + '</td>';
                            rowItem += '<td>' + item.end_date + '</td>';
                            rowItem += '<td>' + item.oav_number + '</td>';
                            rowItem += '<td>' + item.company_name + '</td>';
                            rowItem += '<td>' + item.email + '</td>';
                            rowItem += '<td>' + item.address + '</td>';
                            rowItem += '<td class="check"></td>';
                            rowItem += '</tr>';
                        });
                        dataTableUser.destroy();
                        tbody.html(rowItem);
                        dataTableUser = $("#data-table-users").DataTable({
                            'paging': true,
                            "pagingType": "simple_numbers",
                            'lengthChange': true,
                            'searching': true,
                            'info': true,
                            'autoWidth': false,
                            'stateSave': true,
                            'columnDefs': [{
                                orderable: false,
                                className: 'select-checkbox',
                                targets: 8
                            }],
                            'select': {
                                style: 'multi',
                                selector: 'td:last-child'
                            }
                        });
                    }
                }
            });
        });
    });
</script>
@endpush
