@extends('layouts.color_admin.default')
@section('title', 'Exporteren')

@section('content')
    <div class="a-page-content">
        <div class="breadcomb-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="breadcomb-list">
                            <form id="form-exporteren" method="post" data-url="{{route('admin.dec.exporteren')}}" action="{{route('admin.dec.exporteren')}}">
                                @csrf
                                <div class="row">
                                    <div class="col-12" style="padding-left: 30px">
                                        <h3>Exporteren</h3>
                                    </div>
                                </div>

                                @if ($errors->any())
                                    <div class="row mt-3 mb-3">
                                        <div class="col-12">
                                            <div class="alert alert-danger">
                                                <ul style="margin-bottom: 0">
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                
                                <div class="row">
                                    <div class="col-md-2 col-12 text-right a-mt-15">
                                        <span class="a-title-adjust">JAAR</span>
                                    </div>
                                    <div class="col-12 col-md-3 a-mt-15">
                                        <select name="jaar" class="form-control form-control-sm" onchange="updateExporterenUrl()">
                                            @foreach ($years as $year)
                                            <option value="{{$year}}">{{$year}}</option>
                                            @endforeach
                                        </select>
                                    </div>
									<div class="col-md-6 text-left col-12" style="padding: 17px;">
                                        <button type="submit" name="exporteren" value="1" class="btn btn-primary btn-sm">Exporteren</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function updateExporterenUrl() {
            let url_exporteren = $('#form-exporteren').attr('data-url') + '/' + '?y=' + $('select[name="jaar"]').val();
            $('#form-exporteren').attr('action', url_exporteren);
        }
        
        $( document ).ready(function() {
            updateExporterenUrl();
        });
    </script>
@endpush
