@extends('layouts.color_admin.default')
@section('title', 'E-mail')
@section('content')
    <div class="a-page-content">
        <div class="normal-table-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="normal-table-list">
                            <div class="basic-tb-hd a-header-content">
                                <h2>E-mail</h2>
                                <p>Totaal: {{ $list->total() }}</p>
                            </div>
                            @if(Session::has('b_a_email'))
                                <div class="row mt-3">
                                    <div class="col-12">
                                        <div class="alert alert-success">
                                            {{ Session::pull('b_a_email')}}
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="bsc-tbl">
                                <table class="table table-sc-ex">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>E-mail</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($list as $key => $item)
                                        <tr>
                                            <td>{{ ($list->currentPage() - 1) * config('appvalue.paging') + $key + 1 }}</td>
                                            <td>{{ $item->name }}</td>
                                            <td>
                                                <a class="btn btn-sm btn-primary" href="{{ route('admin.email.mailDetail', ['id' => $item->id]) }}">Bijwerken</a>
                                                <a class="btn btn-sm btn-success" href="{{ route('admin.email.previewMail', ['id' => $item->id]) }}" target="_blank">voorvertoning</a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">Geen data.</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-5">
                    <div class="col-12">
                        <div style="padding-left: 15px">
                            {{ $list->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

