@extends('layouts.color_admin.default')
@section('title', 'Aangiften')
@section('content')
    <div class="a-page-content">
        <div class="normal-table-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="normal-table-list xdev-table">
                            <div class="basic-tb-hd a-header-content">
                                <h2>{{$text_title}}</h2>
                                <p>Totaal: {{ count($list) }}</p>
                                <!--<a href="{{ route('admin.dec.aTypeList') }}" class="btn btn-primary btn-sm a-style-btn-crt">
                                    lijst aangiftetype
                                </a>-->
                            </div>
                            <div class="table-responsive">
                                <table id="data-table" class="table table-sc-ex">
                                    <thead>
                                    <tr>
                                        <th>#</th>
										<th>OAVnummer</th>
                                        <th>Bedrijfsnaam</th>
                                        <th>Tijdvak</th>
                                        <th>Omschrijving</th>
                                        <th>Type</th>
                                        <th>Bijgewerkt op</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($list as $key => $item)
										<?php $date_created_at = strtotime($item->declare_date);  ?>
										<?php $date_show = date("d/m/Y H:i:s",$date_created_at);  ?>
                                        <?php $fileNamePdf = $item->file_pdf_name; ?>
                                        <tr>
                                            <td>{{ $key + 1  }}</td>
											<td>{{ $item->oav_number }}</td>
											<td>{{ $item->company_name }}</td>
                                            <td>{{ $item->period }}</td>
                                            <td>{{ $item->description }}</td>
                                            <td>{{ $listPeriodType[$item->type] }}</td>
					   <td data-sort="{{$item->declare_date}}">{{ !empty($item->admin_updated_at) ? $item->admin_updated_at : $date_show }}</td>
                                            <td>
                                                <a href="{{ route('admin.dec.maDetail', ['id' => $item->id]) }}" class="btn btn-sm btn-primary">Detail</a>
                                                <span class="btn btn-danger btn-sm btn-delete-dec" data-id="{{ $item->id }}">VERWIJDEREN</span>
                                                @if ($item->file_pdf_name)
                                                    <a href="{{ route('admin.dec.readpdf', ['id' => $item->id,'user_id' => $item->user_id]) }}" target="_blank" class="btn btn-sm btn-success">PDF</a>
                                                @endif
						<a href="{{"/admin/sendEmailDetail/$item->id"}}"
                                                   class="btn btn-sm btn-primary">Basecone</a>
                                            </td>
                                        </tr>
                                    {{-- @empty
                                        <tr>
                                            <td colspan="5" class="text-center">Geen data.</td>
                                        </tr> --}}
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                {{-- <div class="row mt-5">
                    <div class="col-12">
                        <div style="padding-left: 15px">
                            {{ $list->links() }}
                        </div>
                    </div>
                </div> --}}
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(function () {

            $("#data-table").DataTable({
                'paging': true,
                "pagingType": "simple_numbers",
                'lengthChange': true,
                'searching': true,
                'info': true,
                'autoWidth': false,
                'stateSave': true,
                "language": {
                    "decimal":        "",
                    "emptyTable":     "Geen data beschikbaar in de tabel",
                    "info":           "Toon _START_ tot _END_ van _TOTAL_ items",
                    "infoEmpty":      "Toon 0 van 0 van 0 items",
                    "infoFiltered":   "(gefilterd uit _MAX_ totaal inzendingen)",
                    "infoPostFix":    "",
                    "thousands":      ",",
                    "lengthMenu":     "Toon _MENU_ items",
                    "loadingRecords": "Bezig met laden...",
                    "processing":     "Verwerken...",
                    "search":         "Zoeken:",
                    "zeroRecords":    "Geen overeenkomende records gevonden",
                    "paginate": {
                        "first":      "Eerste",
                        "last":       "Laatste",
                        "next":       "Volgende",
                        "previous":   "Vorige"
                    },
                    "aria": {
                        "sortAscending":  ": activeren om kolom oplopend te sorteren",
                        "sortDescending": ": activeren om kolom aflopend te sorteren"
                    }
                },
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'copy', className: 'btn-sm',
                        exportOptions: {
                            columns: [ 0, 1, 2, 3,4,5 ]
                        } 
                    },
                    { extend: 'csv', className: 'btn-sm',
                        exportOptions: {
                            columns: [ 0, 1, 2, 3,4,5 ]
                        } 
                    },
                    { extend: 'excel', className: 'btn-sm',
                        exportOptions: {
                            columns: [ 0, 1, 2, 3,4,5 ]
                        } 
                    },
                    { extend: 'pdf', className: 'btn-sm',
                        exportOptions: {
                            columns: [ 0, 1, 2, 3,4,5 ]
                        }  
                    },
                    { extend: 'print', className: 'btn-sm',
                        exportOptions: {
                            columns: [ 0, 1, 2, 3,4,5 ]
                        } 
                    }
                ],
            });

            let _page = $('.a-page-content');

            _page.on('click', '.btn-delete-dec', function () {
                let _confirm = confirm('Weet je het zeker?');
                if(_confirm){
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "{{ route('admin.dec.deleteDec') }}",
                        data: {id: $(this).attr('data-id')},
                        type: 'post',
                        success: function(res){
                            if(res.status == "success"){
                                alert('Verwijderd');
                                window.location = location.href;
                            }
                        }
                    });
                }
            });
        });
    </script>
@endpush
