<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserUpdatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_updates', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('user_id');
            $table->string('company_name')->nullable();
            $table->string('address')->nullable();
            $table->string('postcode')->nullable();
            $table->string('place')->nullable();
            $table->string('land')->nullable();
            $table->string('phone')->nullable();
            $table->string('fax')->nullable();
            $table->string('kvk_number')->nullable();
            $table->string('btw_number')->nullable();
            $table->integer('declaration_type')->nullable();
            $table->string('declaration_web')->nullable();
            $table->string('contact')->nullable();
            $table->dateTime('oav_date')->nullable();
            $table->smallInteger('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_updates');
    }
}
