<?php

namespace App\Mail;

use App\Helper\AppConstant;
use App\Models\TemplateEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CreateAdmin extends Mailable
{
    use Queueable, SerializesModels;

    public $password;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($password)
    {
        $this->password = $password;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = TemplateEmail::where('id', AppConstant::MAIL_CREATE_ADMIN)->first();
        if(!empty($template->id)){
            $title = $template->title;
            $text = str_replace('::password::', $this->password, $template->text);
            $button = $template->button;
            $cc = explode(',', $template->cc_email);
            $bcc = explode(',', $template->bcc_email);

            return $this->markdown('emails.template.mail')
                ->subject($title)
                ->cc(empty($cc[0]) ? [] : $cc)
                ->bcc(empty($bcc[0]) ? [] : $bcc)
                ->with([
                    'title' => $title,
                    'text' => $text,
                    'button' => $button,
                    'url' => route('admin.home.index')
                ]);
        } else {
            return $this->markdown('emails.admin.create')
                ->with([
                    'url' => route("admin.home.index"),
                    'password' => $this->password
                ]);
        }
    }
}
