<?php

namespace App\Mail;

use App\Helper\AppConstant;
use App\Models\TemplateEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ChangeUserPass extends Mailable
{
    use Queueable, SerializesModels;
    private $code;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($code)
    {
        $this->code = $code;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = TemplateEmail::where('id', AppConstant::MAIL_USER_PASSWORD)->first();
        if(!empty($template->id)){
            $title = $template->title;
            /* $text = $template->text; */
            $button = $template->button;
            $cc = explode(',', $template->cc_email);
            $bcc = explode(',', $template->bcc_email);
            $text = str_replace('[BUTTON]', '<a style="padding:10px 40px;width:150px;margin:0 auto;text-align:center;background-color:#348fe2;color:#ffffff" href="'. route('newPassword', ['code' => $this->code]) .'">Klik hier en bevestig</a>', $template->text);

            return $this->markdown('emails.template.mail')
                ->subject($title)
                ->cc(empty($cc[0]) ? [] : $cc)
                ->bcc(empty($bcc[0]) ? [] : $bcc)
                ->with([
                    'title' => $title,
                    'text' => $text,
                    'button' => $button,
                    'url' => route('newPassword', ['code' => $this->code])
                ]);
        } else {
            return $this->markdown('emails.user.change')
                ->with([
                    'url' => route('newPassword', ['code' => $this->code])
                ]);
        }

    }
}
