<?php

namespace App\Mail;

use App\Helper\AppConstant;
use App\Models\TemplateEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ChangePassword extends Mailable
{
    use Queueable, SerializesModels;
    private $code;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($code)
    {
        $this->code = $code;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = TemplateEmail::where('id', AppConstant::MAIL_ADMIN_PASSWORD)->first();
        if(!empty($template->id)){
            $title = $template->title;
            $text = $template->text;
            $button = $template->button;
            $cc = explode(',', $template->cc_email);
            $bcc = explode(',', $template->bcc_email);

            return $this->markdown('emails.template.mail')
                ->subject($title)
                ->cc(empty($cc[0]) ? [] : $cc)
                ->bcc(empty($bcc[0]) ? [] : $bcc)
                ->with([
                    'title' => $title,
                    'text' => $text,
                    'button' => $button,
                    'url' => route('admin.password', ['code' => $this->code])
                ]);
        } else {
            return $this->markdown('emails.admin.change_password')
                ->with([
                    'url' => route('admin.password', ['code' => $this->code])
                ]);
        }

    }
}
