<?php



namespace App\Http\Controllers;



use App\Helper\AppConstant;

use App\Helper\MYPDF;

use App\Models\Declaration;

use App\Models\DeclarationType;

use App\Models\Period;

use App\Models\UserPeriod;

use Carbon\Carbon;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Storage;

use Illuminate\Support\Facades\View;

use App\Models\Menu;

use PDF;



class PrintController extends Controller

{

    public function __construct()

    {

        $this->middleware('auth');

        View::share('menu', Menu::all());

    }



    public function create($id)

    {

        $user = Auth::user();



        $declarationModel = new Declaration();

        $declarationObj = $declarationModel->GetDeclarationById($id);

        $listOfDeclareObject = $declarationModel->getListDeclaration($id);

        // get user_period_id

        $userPeriodModel = new UserPeriod();

        $userPeriodId = $userPeriodModel->getPeriodId($declarationObj->user_period_id);



        $periodObj = Period::where('id', $userPeriodId)->firstOrFail();



        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        $pdf->SetCreator(PDF_CREATOR);

        $pdf->SetAuthor('');

        $pdf->SetTitle('');

        $pdf->SetSubject('');

        $pdf->SetKeywords('');

        $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);

        $pdf->SetHeaderMargin(0);

        $pdf->SetFooterMargin(0);

        $pdf->setPrintFooter(true);

        $pdf->SetAutoPageBreak(true, PDF_MARGIN_BOTTOM);

        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);



        $btwpre = "BTW-nr: ";

        $pro_nl222 = $declarationObj->pro_nl;

        $imp_be222 = $declarationObj->imp_be;

        $imp_de222 = $declarationObj->imp_de;

        $imp_po222 = $declarationObj->imp_po;

        $imp_turk222 = $declarationObj->imp_turk;

        $import222 = $declarationObj->import;



        $pro_nl22 = str_replace(".", ",", $pro_nl222);

        $imp_be22 = str_replace(".", ",", $imp_be222);

        $imp_de22 = str_replace(".", ",", $imp_de222);

        $imp_po22 = str_replace(".", ",", $imp_po222);

        $imp_turk22 = str_replace(".", ",", $imp_turk222);

        $import22 = str_replace(".", ",", $import222);



        $statement_date = $periodObj->date_statement->timestamp;

        $statement_date = getdate($statement_date);



        $expiration_date = $periodObj->date_release->timestamp;

        $expiration_date = getdate($expiration_date);



        $signed_date = $declarationObj->date->timestamp;

        $signed_date = getdate($signed_date);



        $pdf->AddPage('P', 'A4');



        $html = '<div>'

            . '<table width="100%">'

            . '<tr>'

            . '<td style="font-size: 80%;">'

            . $user->company_name . '<br />' . $user->contact . '<br />' . $user->address . '<br /> ' . $user->postcode . ', ' . $user->place . '<br />' . $user->postcode

            . '</td>'

            . '<td align="right" style="font-size: 80%;">'

            . '<strong>Bij betaling s.v.p. vermelden</strong><br />'

            . 'debiteuren-nr / factuur-nr <br />'

            . $user->oav_number . ' / ' . $periodObj->period . '<br />' . $user->email . '<br />' . $btwpre . '' . $user->btw_number . '</td>'

            . '</tr>'

            . '<tr>'

            . '<td></td><td align="right" style="font-size: 80%;"><br />Factuurdatum ' . $signed_date['mday'] . ' ' . $this->pickMonth($signed_date['mon']) . ' ' . $signed_date['year'] . '</td>'

            . '</tr>'

            . '</table>'

            . '</div>'

            . '<div>'

            . '<h2 style="text-align:center; margin: -20px 0 0 0; font-size: 90%;">Factuur en opgaveformulier recyclingbijdrage</h2>'

            . '<p style="font-size: 80%;">Betreft: factuur en opgave formulier inzake het aantal gefactureerde m2 isolatieglas op de Nederlandse markt gebracht in het tijdvak ' . $periodObj->description . '</p>'

            . '<ul style="list-style:disc; list-style-position:inside;">'

            . '<li style="font-size: 80%;">Opgave dient uiterlijk binnen te zijn op ' . $statement_date['mday'] . ' ' . $this->pickMonth($statement_date['mon']) . ' ' . $statement_date['year'] . '</li>'

            . '<li style="font-size: 80%;">De betalingstermijn is 30 dagen (vervaldatum ' . $expiration_date['mday'] . ' ' . $this->pickMonth($expiration_date['mon']) . ' ' . $expiration_date['year'] . ')</li>'

            . '</ul>'

            . '<br/>'

            . '<table style="border: 1px solid #000;">'

            . '<thead>'

            . '<tr>'

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Categorie naam</th>' // title declaration type

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Aantal gefactureerde m2 isolatieglas</th>'

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Gewicht<br>(optioneel)</th>'

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Recyclingbijdrage per m2</th>'

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Bijdrage excl. BTW in euro</th>'

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">BTW 21% in euro</th>'

            . '<th style="font-size: 80%; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Bijdrage incl. BTW in euro</th>'

            . '</tr>'

            . '</thead>'

            . '<tbody>';

        $tableDeclaration = "";



        $sumAantal = 0;

        $sumWeight = 0;

        $sumRecyclingbijdra = 0;

        $sumBijdrage = 0;

        $sumBTW = 0;

        $sumIncl = 0;



        foreach ($listOfDeclareObject as $_declare) {

            if (!$_declare->total_m2) {

                $_declare->total_m2 = 0;

            }

            if (!$_declare->weight) {

                $_declare->weight = 0;

            }

            if (!$_declare->unit_price) {

                $_declare->unit_price = 0;

            }

            if (!$_declare->total) {

                $_declare->total = 0;

            }

            if (!$_declare->btw) {

                $_declare->btw = 0;

            }

            if (!$_declare->total_btw) {

                $_declare->total_btw = 0;

            }



            $sumAantal += $_declare->total_m2;

            $sumWeight += $_declare->weight;

            $sumRecyclingbijdra += $_declare->unit_price;

            $sumBijdrage += $_declare->total;

            $sumBTW += $_declare->btw;

            $sumIncl += $_declare->total_btw;



            $itemDeclare =

                '<tr style="border-top: 1px solid #000">'

                . '<td style="font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">' . $_declare->type_name . '<' . $_declare->category_name . '></td>' // title declaration type

                . '<td style="font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">' . $_declare->total_m2 . ' m2</td>'

                . '<td style="font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">' . $_declare->weight . ' kg</td>'

                . '<td style="font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">&euro; ' . $this->amount($_declare->unit_price) . '</td>'

                . '<td style="font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">&euro; ' . $this->amount($_declare->total) . '</td>'

                . '<td style="font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">&euro; ' . $this->amount($_declare->btw) . '</td>'

                . '<td style="font-size: 80%; padding: 4px; text-align:left;">&euro; ' . $this->amount($_declare->total_btw) . '</td>'

                . '</tr>';

            $tableDeclaration .= $itemDeclare;

        }



        $totalTableDeclaration =

            '<tr style="border-top: 1px solid #000">'

            . '<td style="border-top: 1px solid #000;font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">Totaal</td>'

            . '<td style="border-top: 1px solid #000;font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">' . $sumAantal . ' m2</td>'

            . '<td style="border-top: 1px solid #000;font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">' . $sumWeight . ' kg</td>'

            . '<td style="border-top: 1px solid #000;font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">&euro; ' . $this->amount($sumRecyclingbijdra) . '</td>'

            . '<td style="border-top: 1px solid #000;font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">&euro; ' . $this->amount($sumBijdrage) . '</td>'

            . '<td style="border-top: 1px solid #000;font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">&euro; ' . $this->amount($sumBTW) . '</td>'

            . '<td style="border-top: 1px solid #000;font-size: 80%; border-right: 1px solid #000; padding: 4px; text-align:left;">&euro; ' . $this->amount($sumIncl) . '</td>'

            . '</tr>';



        $endOfTableDeclaration =

            '</tbody>'

            . '</table><p style="font-size: 50%;">* Optioneel de OAV gebruikt deze gegevens voor haar registratie en worden vertrouwelijk behandeld.</p>'

            . '<p style="font-size: 60%;">Deze opgave kan worden uitgesplitst in:</p>';

        $html .= $tableDeclaration . "" . $totalTableDeclaration . "" . $endOfTableDeclaration;

        $htmlTableCountry = "";

        $totalTableDeclarationCountry = "";

        $html2 = '<table style="border: 1px solid #000;">'

            . '<thead>'

            . '<tr>'

            . '<th style="font-size: 80%; border-top: 1px solid #000; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Categorie naam</th>'

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Productie in Nederland</th>'

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Import Duitsland</th>'

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Import België</th>'

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Import Polen</th>'

            . '<th style="font-size: 80%; border-right: 1px solid #000; border-bottom: 1px solid #000; padding: 4px; text-align:left;">Import overige</th>'

            . '</tr>';

        $htmlItemCountry = "";

        $total_nl222 = 0.00;

        $total_be = 0.00;

        $total_de = 0.00;

        $total_po = 0.00;

        $total_import = 0.00;

        foreach ($listOfDeclareObject as $_declare) {

            $pro_nl222 = $_declare->pro_nl;

            $imp_be222 = $_declare->imp_be;

            $imp_de222 = $_declare->imp_de;

            $imp_po222 = $_declare->imp_po;

            $imp_turk222 = $_declare->imp_turk;

            $import222 = $_declare->import;



            if (!$pro_nl222) {

                $pro_nl222 = 0;

            }

            if (!$imp_be222) {

                $imp_be222 = 0;

            }

            if (!$imp_de222) {

                $imp_de222 = 0;

            }

            if (!$imp_po222) {

                $imp_po222 = 0;

            }

            if (!$imp_turk222) {

                $imp_turk222 = 0;

            }

            if (!$import222) {

                $import222 = 0;

            }



            $total_nl222 += $pro_nl222;

            $total_be += $imp_be222;

            $total_de += $imp_de222;

            $total_po += $imp_po222;

            $total_turk += $imp_turk222;

            $total_import += $import222;



            $pro_nl22 = str_replace(".", ",", $pro_nl222);

            $imp_be22 = str_replace(".", ",", $imp_be222);

            $imp_de22 = str_replace(".", ",", $imp_de222);

            $imp_po22 = str_replace(".", ",", $imp_po222);

            $imp_turk22 = str_replace(".", ",", $imp_turk222);

            $import22 = str_replace(".", ",", $import222);

            $htmlItemCountry .= '<tr border="1">'

                . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . $_declare->type_name . '</td>'

                . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . $pro_nl222 . ' m2 </td>'

                . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . $imp_be222 . ' m2</td>'

                . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . $imp_de222 . ' m2</td>'

                . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . $imp_po222 . ' m2</td>'

                . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . $imp_turk222 . ' m2</td>'

                . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . $import222 . '  m2</td>'

                . '</tr>';



        }

        $totalTableDeclarationCountry .= '<tr style="border-top: 1px solid #000">'

            . '<td style="font-size: 80%; padding: 4px; text-align:left;">Totaal</td>'

            . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . str_replace(".", ",", strval($total_nl222)) . ' m2</td>'

            . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . str_replace(".", ",", strval($total_de)) . ' m2</td>'

            . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . str_replace(".", ",", strval($total_be)) . ' m2</td>'

            . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . str_replace(".", ",", strval($total_po)) . ' m2</td>'

            . '<td border="1" style="font-size: 80%; padding: 4px; text-align:left;">' . str_replace(".", ",", strval($total_import)) . '  m2</td>'

            . '</tr>';

        $endTableCountry = '</thead>'

            . '</table>';

        $htmlTableCountry = $html2 . "" . $htmlItemCountry . "" . $totalTableDeclarationCountry . "" . $endTableCountry;

        $caption1 = '<p style="font-size: 70%;">Met dit formulier doet u opgave voor de recyclingbijdrage over het bovengenoemde tijdvak. Over het bedrag van de recyclingbijdrage wordt u omzetbelasting in rekening gebracht. Vul het formulier ALTIJD in, ook als u over dit tijdvak geen recyclingbijdrage bent verschuldigd.</p>'

            . '<p style="font-size: 70%;">Gelieve het aantal gefactureerde m2 isolatieglas, bijdrage exclusief BTW in euro, BTW-bedrag in euro en bijdrage inclusief BTW in euro in te vullen.</p>'

            . '<p style="font-size: 70%;">Het bedrag van de verschuldigde recyclingbijdrage inclusief BTW moet u betalen voor bovenstaande datum op bankrekeningnummer IBAN: NL10RABO 0322 4366 05 t.n.v. Fonds Vlakglas Recycling Nederland, Zoetermeer.</p>'

            . '<p style="font-size: 70%;">Dit formulier hoeft niet verzonden te worden en is voor uw eigen administratie bestemd; u hebt digitaal opgave gedaan. Mocht u vragen en/of opmerkingen hebben dan kunt u contact opnemen met de OAV (Onafhankelijke Administratie Vlakglas), telefoon 088-5678805.</p>';

        $caption2 = '<div>'

            . '<h3 style="font-size: 70%;">Ondertekening</h3>'

            . '<p style="font-size: 70%;">Ik verklaar deze opgave duidelijk, stellig en zonder voorbehoud te hebben ingevuld</p>'

            . '<table>'

            . '<tr>'

            . '<td style="font-size: 70%;">Plaats:</td><td style="font-size: 80%;">' . $declarationObj->place . '</td>'

            . '<td style="font-size: 70%;">Telefoon:</td><td style="font-size: 80%;">' . $declarationObj->phone . '</td>'

            . '</tr>'

            . '<tr>'

            . '<td style="font-size: 70%;">Datum:</td><td style="font-size: 80%;">' . $signed_date['mday'] . '  ' . $this->pickMonth($signed_date['mon']) . '  ' . $signed_date['year'] . ' </td>'

            . '<td style="font-size: 70%;">Naam:</td><td style="font-size: 80%;">' . $declarationObj->name . '</td>'

            . '</tr>'

            . '</table>'

            . '</div>'

            . '<div style="font-size: 60%; letter-spacing: 0; text-align:center;">';

        /* . '<p>Fonds Vlakglas Recycling Nederland - Postbus 340, 2700 AH Zoetermeer - Tel: 088-5678805<br />E-mail: info@oavaangifte.nl - BTW nr. 8564.33.779.B.01 - KvK 66188482</p>'; */





        $pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

        $pdf->writeHTMLCell(0, 0, '', '', $htmlTableCountry, 0, 1, 0, true, '', true);

        $pdf->writeHTMLCell(0, 0, '', '', $caption1, 0, 1, 0, true, '', true);

        $pdf->writeHTMLCell(0, 0, '', '', $caption2, 0, 1, 0, true, '', true);

        //Add Page có 2 params là $orientation và $format là định hướng potrait hoặc landscape, format là định dạng A4 hay A5



        $current_timestamp = Carbon::now()->timestamp; // Produces something like 1552296328

        $file_name = $user->user_name . "_" . $periodObj->period . '_' . $current_timestamp . ".pdf";



        // get path to save file pdf

        $path = Storage::disk('public')->path("pdf");



        // save file pfd

        $pdf->Output($path . '/' . $file_name, 'F');



        // update file name pdf to user periods

        $userPeriodModel->updateFilePdfNameById($declarationObj->user_period_id, $file_name);



        // download file pdf

        $pdf->Output($file_name, 'D');

    }



    private function amount($cents)

    {

        return number_format(($cents / 100), 2, ',', '');

    }



    private function pickMonth($month)

    {

        if ($month == 1) {

            $monthname = 'januari';

        } elseif ($month == 2) {

            $monthname = 'februari';

        } elseif ($month == 3) {

            $monthname = 'maart';

        } elseif ($month == 4) {

            $monthname = 'april';

        } elseif ($month == 5) {

            $monthname = 'mei';

        } elseif ($month == 6) {

            $monthname = 'juni';

        } elseif ($month == 7) {

            $monthname = 'juli';

        } elseif ($month == 8) {

            $monthname = 'augustus';

        } elseif ($month == 9) {

            $monthname = 'september';

        } elseif ($month == 10) {

            $monthname = 'oktober';

        } elseif ($month == 11) {

            $monthname = 'november';

        } elseif ($month == 12) {

            $monthname = 'december';

        } else {

            return false;

        }

        return $monthname;

    }



    public function printCertification($year, $next_period)

    {

        $user = Auth::user();

        $data = [

            'user' => $user,

            'year' => $year,

            'next_period' => $next_period

        ];

        $pdf = PDF::loadView('dompdf.certificate', $data);

        $current_timestamp = Carbon::now()->timestamp; // Produces something like 1552296328

        $file_name = "Verklaring_afdracht_" . $year . ".pdf";

        $path = Storage::disk('public')->path("pdf");

        $pdf->Output($path . '/' . $file_name, 'F');

        return $pdf->save($path . '/' . $file_name)->download($file_name);

        /*$dec = new Declaration();

        $user = Auth::user();

        //if(!$dec->checkCert($year, $user->id)){

            //abort(404);

        //}

        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);



        $pdf->SetCreator(PDF_CREATOR);

        $pdf->SetAuthor('Vlakglas Recycling Nederland');

        $pdf->SetTitle('Verklaring Afdracht');

        $pdf->SetSubject('Verklaring Afdracht');

        $pdf->SetKeywords('');

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);

        $pdf->SetHeaderMargin(0);

        $pdf->SetFooterMargin(0);

        $pdf->setPrintFooter(false);

        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        $pdf->AddPage();

        $pdf->SetMargins(50, 50, 10, true);



        $name = $user->first_name . ' ' . $user->last_name;

        $address = $user->address;

        $postcode = $user->postcode;

        $place = $user->place;

        $year = $year;

        $oavNumber = $user->oav_number;



        $html = '<br><br><br><br><br><span style="color:black;text-align:left;font-weight:bold;font-size:22pt;">Bewijs van deelname</span><br><br><br>

            <span style="color:black;text-align:left;font-family:verdana;font-size:10pt;">In het kader van het besluit met kenmerk IenM/BSK-2016/123876 van de Staatssecretaris van Infrastructuur en Milieu, inzake de recyclingbijdrage op vlakglas waarvan mededeling is gedaan in de Staatscourant nr. 34134 d.d. 29 juni 2016<br><br>

            Teneinde een doelmatig en kostendekkend landelijk verwijderingssysteem voor vlakglas uit te voeren, heeft</span><br><br>

            <span style="color:black;text-align:left;font-weight:bold;font-family:verdana;font-size:12pt;"><br>

            <br>'.$name.'<br>'.$address.'<br>'.$postcode.' '.$place.'<br><br><br></span><span style="color:black;text-align:left;font-family:verdana;font-size:10pt;"><br>

            Zich verplicht tot het afdragen van een recyclingbijdrage op isolatieglas ten bedrage van € 0,40 per vierkante meter (exclusief BTW).

            <br><br>';



        $pdf->writeHTML($html, true, false, true, false, '');



        $tbl = '

            <table cellspacing="0" cellpadding="1" border="0">

                <tr>

                    <td style="color:black;text-align:left;font-family:verdana;font-size:10pt;">Stichting Fonds Vlakglas Recycling Nederland</td>

                    <td style="color:black;text-align:left;font-family:verdana;font-size:10pt;">Stichting Vlakglas Recycling Nederland</td>

                </tr>

                <tr>

                    <td style="color:black;text-align:left;font-family:verdana;font-size:10pt;">C. Wittekoek<br>Directeur</td>

                    <td style="color:black;text-align:left;font-family:verdana;font-size:10pt;">H.J. de Vlam<br>Voorzitter</td>

                </tr>

                <tr>

                    <td align="left" style="width:60%;color:black;text-align:left;font-family:verdana;font-size:10pt;"><br><br><br><br>Dit bewijs is geldig t/m 31 december '. $year .'<br><br></td>

                    <td align="right" style="width:35%;color:black;text-align:left;font-family:verdana;font-size:10pt;"><br><br><br><br>Nummer:'.$oavNumber.'<br><br></td>

                </tr>

                <tr>

                    <td style="color:black;text-align:left;font-family:verdana;font-size:10pt;"><br><br><br><br></td>

                    <td style="color:black;text-align:left;font-family:verdana;font-size:10pt;"><br><br><br><br></td>

                </tr>

            </table>';





        $pdf->writeHTML($tbl, true, false, false, false, '');



        $tbl2 = '<table>'.

                '<tr>'.

                    '<td>'.

                        '<span style="color:black;text-align:left;font-family:verdana;font-size:8.1pt;">De Minister heeft de overeenkomst inzake de afvalbeheersbijdrage voor vlakglas algemeen verbindend verklaard, hetgeen betekent dat alle producenten en / of importeurs die voor het eerst vlakglas afzetten op de Nederlandse markt en die al dan niet bij de Stichting Vlakglas Recycling Nederland zijn aangesloten, zijn verplicht tot het afdragen van de recyclingbijdrage. Deelname aan het verwijderingssysteem is alleen mogelijk bij lidmaatschap van de Stichting Vlakglas Recycling Nederland. Genoemd bedrijf voldoet aan deze voorwaarden

                            <br><br>Het niet nakomen van de aan deze verplichting gestelde eisen leidt tot het ongeldig verklaren van dit bewijs.

                            <br><br>Dit bewijs blijft eigendom van de Onafhankelijke Administratie Vlakglas.

                        </span>

                    </td>

                </tr>

            </table> ';



        $pdf->writeHTML($tbl2, true, false, false, false, '');

        $pdf->Output('Verklaring_afdracht.pdf', 'D');*/

    }



    public function createDomPdf($id)

    {

        set_time_limit(300);



        $user = Auth::user();

        $userPeriod = new UserPeriod();

        $year = $userPeriod->getYearOfPeriod($id);

        $declarationModel = new Declaration();

        $declarationObj = $declarationModel->GetDeclarationById($id, $year < 2022 ? 'lower' : 'upper');

        $listOfDeclareObject = $declarationModel->getListDeclaration($id, $year < 2022 ? 'lower' : 'upper');

        // get user_period_id

        $userPeriodModel = new UserPeriod();

        $userPeriodId = $userPeriodModel->getPeriodId($declarationObj->user_period_id);

        $userPeriod = $userPeriodModel->getPeriodData($declarationObj->user_period_id);

        $periodObj = Period::where('id', $userPeriodId)->firstOrFail();

        $year = $periodObj->group_period;

        /* check if Q6 */

        if ($year < 2022) {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('old_sort', '>=', 1)
                ->orderBy('old_sort', 'asc')->get();
        } else {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('sort', '>=', 1)
                ->orderBy('sort', 'asc')->get(); // phmd
        }
        if( $year >= 2025 ){
            //triple isolatieglas, dubbel isolatieglas, 
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->whereIn('id', [14,12,13])
                ->orderBy('sort', 'asc')->get(); // phmd
        }

        $file_name = $userPeriod->file_pdf_name;

        if ($file_name != "") {

            if (strpos($file_name, "-") === false) {

                $file_name = str_replace(".pdf", "", $file_name);

                $current_timestamp = Carbon::now()->timestamp;

                $newFilePdf = $file_name . "-" . $current_timestamp . ".pdf";

                UserPeriod::where('id', $id)

                    ->update([

                        'file_pdf_name' => $newFilePdf

                    ]);

                $file_name = $newFilePdf;

            }

        } else {

            $user_period_id = $declarationObj->user_period_id;

            $period_id = $userPeriod->getPeriodId($user_period_id);

            $numberPDF = $userPeriod->getCountNumberInPeriodIdWithPDF($period_id);

            $numberPDF++;

            $current_timestamp = Carbon::now()->timestamp;

            $file_name = $periodObj->period . '' . $numberPDF . "-" . $current_timestamp . ".pdf";

            // update file name pdf to user periods

            $userPeriodModel->updateFilePdfNameById($declarationObj->user_period_id, $file_name);

        }

        $file_name_data = str_replace(".pdf", "", $file_name);

        $period_in_file = explode("-", $file_name);

        $show_period = $file_name_data;

        if (count($period_in_file) > 1) {

            $show_period = $period_in_file[0];

        }

        $data = [

            'user' => $user,

            'declarationObj' => $declarationObj,

            'listOfDeclareObject' => $listOfDeclareObject,

            'periodObj' => $periodObj,

            'file_name_data' => $show_period,

            'userPeriod' => $userPeriod,

            'listType' => $listType,

            'year' => $year

        ];



        $pdf = PDF::loadView('dompdf.declaration', $data);



        $current_timestamp = Carbon::now()->timestamp; // Produces something like 1552296328

        //First get count user make pdf for this period and increase number

        //$number = $periodObj->id;

        //$file_name = $periodObj->period.''.$current_timestamp.".pdf";

        // get path to save file pdf

        $path = Storage::disk('public')->path("pdf");

        // save file pfd

        $pdf->Output($path . '/' . $file_name, 'F');

        return $pdf->save($path . '/' . $file_name)->download($file_name);

    }



    public function createCreditMemoPdf($id, $year)

    {

        set_time_limit(300);



        $user = Auth::user();

        $userPeriod = new UserPeriod();

        $declarationModel = new Declaration();

        $periodModel = new Period();

        //Sum total

        $currentYear = trim($year);

        $activePeriod = $userPeriod->getActivePeriod($user->id, $currentYear);

        $user_period_id = $id;

        $nameOfPeriod = "Q1_4";

        $titleInPDF = $currentYear . " Q1 t/m Q4";

        if (strpos($activePeriod, "Q5") > 1) {

            $nameOfPeriod = "Q5";

            $titleInPDF = $currentYear . " Q5";

        }





        $user_period_ids = $this->_get_user_period_ids($year, $user->id);





        $listOfDeclaration = $declarationModel->getDeclarationByUserId($user->id, $user_period_ids);

        $listOfFilterDataForSumDeclaration = $declarationModel->getListOfDeclarationByUserIdAndSeperateByType($user->id, $user_period_ids);

        $sumAantal = 0;

        $sumWeight = 0;

        $sumRecyclingbijdra = 0;

        $sumBijdrage = 0;

        $sumBTW = 0;

        $sumIncl = 0;

        $currentTimestamp = Carbon::now()->timestamp;

        $datePrint = Carbon::now()->format("d-m-Y");

        $periodObjFromCurrentYear = Period::where('period', $currentYear . "Q6")->firstOrFail();

        $numberPDF = $userPeriod->getCountNumberInPeriodIdWithPDF($periodObjFromCurrentYear->id);

        $numberPDF++;

        foreach ($listOfDeclaration as $_declare) {

            if (!$_declare->total_m2) {

                $_declare->total_m2 = 0;

            }

            if (!$_declare->weight) {

                $_declare->weight = 0;

            }

            if (!$_declare->unit_price) {

                $_declare->unit_price = 0;

            }

            if (!$_declare->total) {

                $_declare->total = 0;

            }

            if (!$_declare->btw) {

                $_declare->btw = 0;

            }

            if (!$_declare->total_btw) {

                $_declare->total_btw = 0;

            }



            $sumAantal += $_declare->total_m2;

            $sumWeight += $_declare->weight;

            $sumRecyclingbijdra = $_declare->unit_price;

            $sumBijdrage += $_declare->total;

            $sumBTW += $_declare->btw;

            $sumIncl += $_declare->total_btw;

        }

        $arrayTotalRecyclingbijdrage = array(

            "m_2" => $sumAantal,

            "weight" => $sumWeight,

            "unit_price" => $sumRecyclingbijdra,

            "btw" => $sumBijdrage,

            "btw_21" => $sumBTW,

            "btw_euro" => $sumIncl

        );

        $periodObj = $activePeriod;

        $data = [

            'user' => $user,

            'periodObj' => $periodObj,

            'total_value' => $arrayTotalRecyclingbijdrage,

            'list_of_declaration' => $listOfFilterDataForSumDeclaration,

            'title_in_pdf' => $titleInPDF,

            'current_year' => $currentYear,

            'number_correctie' => $numberPDF,

            'date_print' => $datePrint

        ];

        //return view('dompdf.creditmemo',$data);

        $pdf = PDF::loadView('dompdf.creditmemo', $data);

        $file_name = $nameOfPeriod . '_' . $numberPDF . "-" . $currentTimestamp . ".pdf";

        // get path to save file pdf

        $path = Storage::disk('public')->path("pdf");

        $path = public_path('storage/pdf');

        $full_path = $path . '/' . $file_name;



        // save file pfd

        $pdf->Output($full_path, 'F');

        // update file name pdf to user periods

        //$userPeriodModel->updateFilePdfNameById($declarationObj->user_period_id,$file_name);



        //return $pdf->save($path.'/'.$file_name)->download($file_name);



        $pdf->save($path . '/' . $file_name);

        $params = array(

            "pdf_file" => $file_name,

            "period_year" => $year,

            "user_period_id" => $user_period_id

        );

        return view('front.show-credit-memo', $params);

    }



    public function createQuarterSix($id, $year)

    {

        $user = Auth::user();

        $userPeriod = new UserPeriod();

        $declarationModel = new Declaration();

        $userPeriodModel = new UserPeriod();

        $user_period_id = $id;

        $user_period_ids = $this->_get_user_period_ids($year, $user->id);





        $listOfDeclaration = $declarationModel->getDeclarationByUserId($user->id, $user_period_ids);

        $listOfFilterDataForSumDeclaration = $declarationModel->getListOfDeclarationByUserIdAndSeperateByType($user->id, $user_period_ids);

        $arrayDataSumOfDeclaration = array();

        $currentYear = trim($year);

        $activePeriod = $userPeriod->getActivePeriod($user->id, $currentYear);



        $datePrint = Carbon::now()->format("d-m-Y");

        $nameOfPeriod = "Q6";

        $titleInPDF = $currentYear . " Q1 t/m Q4";

        if (strpos($activePeriod, "Q5") > 1) {

            $titleInPDF = $currentYear . " Q5";

        }

        foreach ($listOfFilterDataForSumDeclaration as $_sum_declaration) {

            $arrayDataSumOfDeclaration[$_sum_declaration->type_id] = $_sum_declaration;

        }

        $sumAantal = 0;

        $sumWeight = 0;

        $sumRecyclingbijdra = 0;

        $sumBijdrage = 0;

        $sumBTW = 0;

        $sumIncl = 0;

        $periodObjFromCurrentYear = Period::where('period', $currentYear . "Q6")->firstOrFail();

        $numberPDF = $userPeriod->getCountNumberInPeriodIdWithPDF($periodObjFromCurrentYear->id);

        $numberPDF++;

        foreach ($listOfDeclaration as $_declare) {

            if (!$_declare->total_m2) {

                $_declare->total_m2 = 0;

            }

            if (!$_declare->weight) {

                $_declare->weight = 0;

            }

            if (!$_declare->unit_price) {

                $_declare->unit_price = 0;

            }

            if (!$_declare->total) {

                $_declare->total = 0;

            }

            if (!$_declare->btw) {

                $_declare->btw = 0;

            }

            if (!$_declare->total_btw) {

                $_declare->total_btw = 0;

            }



            $sumAantal += $_declare->total_m2;

            $sumWeight += $_declare->weight;

            $sumRecyclingbijdra = $_declare->unit_price;

            $sumBijdrage += $_declare->total;

            $sumBTW += $_declare->btw;

            $sumIncl += $_declare->total_btw;

        }

        //Get quater six on current year

        $listOfQuaterSix = $declarationModel->getListOfDeclarationQuaterSix($user->id, $id);

        //Get list of delta

        $arrayDelta = array();

        foreach ($listOfQuaterSix as $_quater_six) {

            //check name of type

            $type_id = $_quater_six->type_id;

            $type_name = $_quater_six->type_name;

            $declarationSum = $arrayDataSumOfDeclaration[$type_id];

            //Region for sum data

            $total_pro_nl = $declarationSum->total_pro_nl;

            $total_imp_be = $declarationSum->total_imp_be;

            $total_imp_de = $declarationSum->total_imp_de;

            $total_imp_po = $declarationSum->total_imp_po;

            $total_imp_turk = $declarationSum->total_imp_turk;

            $total_import = $declarationSum->total_import;

            //End region

            $pro_nl = $_quater_six->pro_nl;

            $imp_be = $_quater_six->imp_be;

            $imp_de = $_quater_six->imp_de;

            $imp_po = $_quater_six->imp_po;

            $imp_turk = $_quater_six->imp_turk;

            $import = $_quater_six->import;

            $total_m2 = $_quater_six->total_m2;

            $weight = $_quater_six->weight;

            $unit_price = $_quater_six->unit_price;

            $total = $_quater_six->total;

            $btw = $_quater_six->btw;

            $total_btw = $_quater_six->total_btw;

            //Calculate Delta

            $delta_pro_nl = $pro_nl - $total_pro_nl;

            $delta_imp_be = $imp_be - $total_imp_be;

            $delta_imp_de = $imp_de - $total_imp_de;

            $delta_imp_po = $imp_po - $total_imp_po;

            $delta_imp_turk = $imp_turk - $total_imp_turk;

            $delta_import = $import - $total_import;

            $itemDelta = array();

            $itemDelta['type_name'] = $type_name;

            $itemDelta['pro_nl'] = $delta_pro_nl > 0 ? '+' . $delta_pro_nl : $delta_pro_nl;

            $itemDelta['imp_be'] = $delta_imp_be > 0 ? '+' . $delta_imp_be : $delta_imp_be;

            $itemDelta['imp_de'] = $delta_imp_de > 0 ? '+' . $delta_imp_de : $delta_imp_de;

            $itemDelta['imp_po'] = $delta_imp_po > 0 ? '+' . $delta_imp_po : $delta_imp_po;

            $itemDelta['imp_turk'] = $delta_imp_turk > 0 ? '+' . $delta_imp_turk : $delta_imp_turk;

            $itemDelta['import'] = $delta_import > 0 ? '+' . $delta_import : $delta_import;

            $arrayDelta[] = $itemDelta;

        }

        $arrayTotalRecyclingbijdrage = array(

            "m_2" => $sumAantal,

            "weight" => $sumWeight,

            "unit_price" => $sumRecyclingbijdra,

            "btw" => $sumBijdrage,

            "btw_21" => $sumBTW,

            "btw_euro" => $sumIncl

        );

        $periodObj = Period::where('period', $currentYear . "Q6")->firstOrFail();

        $data = [

            'user' => $user,

            'periodObj' => $periodObj,

            'total_value' => $arrayTotalRecyclingbijdrage,

            'list_of_declaration' => $listOfFilterDataForSumDeclaration,

            'list_of_declaration_q_6' => $listOfQuaterSix,

            'list_of_delta' => $arrayDelta,

            'title_in_pdf' => $titleInPDF,

            'current_year' => $currentYear,

            'number_correctie' => $numberPDF,

            'date_print' => $datePrint

        ];





        //return view('dompdf.creditmemo',$data);

        $pdf = PDF::loadView('dompdf.q_six', $data);



        $current_timestamp = Carbon::now()->timestamp; // Produces something like 1552296328

        $file_name = $nameOfPeriod . '_' . $numberPDF . "-" . $current_timestamp . ".pdf";

        // get path to save file pdf

        $path = Storage::disk('public')->path("pdf");



        // save file pfd

        $pdf->Output($path . '/' . $file_name, 'F');

        // update file name pdf to user periods

        $userPeriodModel->updateFilePdfNameById($id, $file_name);



        return $pdf->save($path . '/' . $file_name)->download($file_name);

    }



    private function _get_user_period_ids($year, $user_id)

    {

        $period_ids = Period::select('id')

            ->where('group_period', '=', $year)

            ->where('period', "not like", "%Q6%")

            ->get()

            ->toArray();



        foreach ($period_ids as $key => $period_id) {

            $period_ids[$key] = $period_id['id'];

        }

        $user_period_ids = UserPeriod::select('id')

            ->whereIn('period_id', $period_ids)

            ->where('user_id', '=', $user_id)

            ->get()

            ->toArray();



        foreach ($user_period_ids as $key => $user_period_id) {

            $user_period_ids[$key] = $user_period_id['id'];

        }



        return $user_period_ids;

    }

}

