<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Mail\ChangePassword;
use App\Mail\ChangeUserPass;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function username()
    {
        return 'user_name';
    }

    protected function credentials(Request $request)
    {
        $data = $request->only($this->username(), 'password');
        $data['active'] = 1;
        return $data;
    }

    public function forgot()
    {
        return view('auth.passwords.recovery');
    }

    public function changePass(Request $request)
    {
        $data = $request->all();
        $validator = Validator::make($data, [
            'email' => 'required|email'
        ]);

        if ($validator->fails()) {
            return redirect(route('forgot'))
                ->withErrors($validator->errors())
                ->withInput();
        } else {
            $user = User::where('email', $data['email'])->first();
            if (empty($user->id)) {
                return redirect(route('forgot'))
                    ->withErrors(['email' => 'invalid'])
                    ->withInput();
            } else {
                $code = time() . Str::random(16);
                $user->forgot_code = $code;
                $user->save();

                Mail::to(trim($data['email']))->queue(new ChangeUserPass($code));
                return redirect(route('recovery'));
            }
        }
    }

    public function recovery()
    {
        return view('auth.passwords.thank');
    }

    public function newPassword($code)
    {
        $user = User::where('forgot_code', $code)->firstOrFail();

        $params = [
            'code' => $code
        ];
        return view('auth.passwords.change', $params);
    }

    public function finishChange(Request $request)
    {
        $data = $request->all();
        $validator = Validator::make($data, [
            'code' => 'required',
            'password' => 'required',
            're_password' => 'required|same:password'
        ]);

        if (!$validator->fails()) {
            $user = User::where('forgot_code', $data['code'])->first();
            if (!empty($user->id)) {
                $user->password = Hash::make($data['password']);
                $user->forgot_code = null;
                $user->save();

                return redirect(route('login'))->withInput(['user_name' => $user->user_name]);
            }
        }

        return redirect(route('newPassword', ['code' => $data['code']]))
            ->withErrors(['password' => 'invalid']);
    }

    protected function authenticated(Request $request, $user)
    {
        // \App\Models\Period::autoGenerateForYear(date('Y'));
        // \App\Models\UserPeriod::autoGenerateForUser($user->id, date('Y'));

        $user = $this->guard()->user();
        if ($user->is_first_time == 0) {
            $modelUser = new User();
            $user_id = $user->id;
            $modelUser->updateUserLoginFirstTime($user_id);
            return redirect()->route('home.mg');
        } else {
            return redirect()->route('home.index')->with(['b_message' => 'Er is een opgeslagen versie van uw aangifte. In het menu "Mijn aangifte" kunt u verder met het verwerken van deze aangifte.']);
        }
    }
}
