<?php

namespace App\Http\Controllers\Admin;

use App\Models\Period;
use App\Exports\MalistExport;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;

class ExporterenController extends Controller
{
    public function index()
    {
        // get years
        $years = Period::selectRaw('DISTINCT periods.group_period')
            ->orderBy('periods.group_period', 'desc')
            ->pluck('group_period')
            ->toArray();

        $params = ['years' => $years];

        // selected year
        if (isset($_GET['y']) && $_GET['y'] > 0) {
            $y = $_GET['y'];

            // start
            return Excel::download(new MalistExport($y), 'malist_export_' . $y . '.xlsx');
        }

        // return
        return view('admin.exporteren.index', $params);
    }
}
