<?php





namespace App\Http\Controllers\Admin;





use App\Helper\AppConstant;

use App\Http\Controllers\Controller;

use App\Models\Declaration;

use App\Models\DeclarationType;

use App\Models\User;

use App\Models\UserPeriod;

use App\Models\Period;

use App\Models\Categories;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Validator;

use Illuminate\Support\Facades\Mail;

use App\Mail\InvoiceMail;

use App\Mail\DeclarationAdmin;

use Carbon\Carbon;

use Illuminate\Support\Facades\Storage;

use PDF;



use Illuminate\Support\Facades\Schema; // phmd



class DeclarationController extends Controller

{

    const STATUS_CREATED = 1;

    public function maList(){

        /* $userPeriod = new UserPeriod();

        $list = $userPeriod->getListForAdmin();

        $listPeriodType = AppConstant::getListPeriodType(); */

        $totalData = UserPeriod::where('user_periods.status', self::STATUS_CREATED)->count();

        $text_title = "Aangiften";

        $params = [

            'text_title' => $text_title,

            'list' => $totalData

        ];



        return view('admin.declaration.index', $params);

    }



    public function getMaList(Request $request){

        $columns = array(

			0 => 'stt',

			1 => 'oav_number',

			2 => 'company_name',

            3 => 'period',

            4 => 'description',

            5 => 'type',

            6 => 'updated_at',

            7 => 'table_action'

		);



        $userPeriod = new UserPeriod();



        $listPeriodType = AppConstant::getListPeriodType();



        $totalData = UserPeriod::where('user_periods.status', self::STATUS_CREATED)->count();

		$limit = $request->input('length');

		$start = $request->input('start');

		$order = $columns[$request->input('order.0.column')];

        $dir = $request->input('order.0.dir');

        if($order == "stt" || $order == "table_action"){

            $order = "user_periods.updated_at";

            $dir = "desc";

        }

        if($order == "updated_at"){

            $order = "user_periods.updated_at";

        }

        if($order == "type"){

            $order = "periods.type";

        }

        if($order == "period"){

            $order = "periods.period";

        }



        if(empty($request->input('search.value'))){

			$posts = $userPeriod->getListForAdmin($start,$limit,null)->orderBy($order,$dir)->get();

			$totalFiltered = $totalData;

		}else{

			$search = $request->input('search.value');

            $posts = $userPeriod->getListForAdmin($start,$limit,$search)->orderBy($order,$dir)->get();

			$totalFiltered = $userPeriod->getListForAdmin(null,null,$search)->count();

		}



        $data = array();



        if($posts){

			foreach($posts as $index => $r){

                $fileNamePdf 	= $r->file_pdf_name;

                $agree 			= $r->agree_on_creditmemo;

                $date_created_at = strtotime($r->declare_date);

                $date_show = date("d/m/Y H:i:s",$date_created_at);

		 $file_name_data = str_replace(".pdf","",$fileNamePdf);

	    if(strpos($file_name_data,"-") === false){

#                    $file_name_data = "";

                }else{

                    $array_file_name = explode("-",$file_name_data);

                    $file_name_data = $array_file_name[0];

                }

                $nestedData['stt'] = $start + $index + 1;

                $nestedData['oav_number'] = $r->oav_number;

                $nestedData['company_name'] = $r->company_name;

		$nestedData['order_id'] = $file_name_data;

		$nestedData['file_name'] = $fileNamePdf;

                $nestedData['period'] = $r->period;

                $nestedData['description'] = $r->description;

                $nestedData['status'] = $r->status;

                $nestedData['type'] = $listPeriodType[$r->type];

                if($r->admin_updated_at){

                    $date_show = $r->admin_updated_at->format('d/m/Y H:i:s');

                }

                $nestedData['updated_at'] = $date_show;



                $pdf_button = "";

                if ($r->file_pdf_name){

                    $pdf_button = '<a href="/admin/readPdf/'.$r->id.'/'.$r->user_id.'" target="_blank" class="btn btn-sm btn-success">PDF</a>';

					if( $agree ){

						$nestedData['description'] = 'geaccepteerd';

						$path = '/storage/pdf';

						$pdf_button = '<a href="'.$path.'/'.$r->file_pdf_name.'" target="_blank" class="btn btn-sm btn-success">PDF</a>';

					}

                }



				if( $agree ){

					$nestedData['table_action'] = '

                    <span class="btn btn-danger btn-sm btn-delete-dec" data-id="'.$r->id.'">VERWIJDEREN</span>

                    '.$pdf_button.'

				';

				}else{

					$nestedData['table_action'] = '

                    <a href="/admin/maDetail/'.$r->id.'" class="btn btn-sm btn-primary">Detail</a>

                    <span class="btn btn-danger btn-sm btn-delete-dec" data-id="'.$r->id.'">VERWIJDEREN</span>

                    '.$pdf_button.'

                    <a href="/admin/sendEmailDetail/'.$r->id.'" class="btn btn-sm btn-primary">Basecone</a>

				';

				}





				$data[] = $nestedData;

			}

		}



		$json_data = array(

			"draw"			=> intval($request->input('draw')),

			"recordsTotal"	=> intval($totalData),

			"recordsFiltered" => intval($totalFiltered),

			"data"			=> $data

		);

        return \response()->json($json_data,200);

    }



    /**

     * Re-send email to admin

     *

     * @param [type] $id period_id

     * @return void

     */

    public function sendEmailDetail($id){

        try {

            $userPeriodModel = new UserPeriod();

            $dec = $userPeriodModel->getDetailForAdmin($id);

            if(count($dec) > 0){

                $user = User::where('id', $dec[0]->user_id)->firstOrFail();

                $params = [

                    'id' => $id,

                    'dec' => $dec,

                    'user' => $user

                ];

                $date_declaration = $dec[0]->declaration_date;

                $userPeriod = $userPeriodModel->getPeriodById($id);

                $file_name = $userPeriod->file_pdf_name;

                $path = Storage::disk('public')->path("pdf");

                $full_path = $path.'/'.$file_name;

                $place = $dec[0]->place;

                $name = $dec[0]->name;

                $phone = $dec[0]->phone;

                $period = $dec[0]->period;





                if( AppConstant::getAdminEmail() ){

                    Mail::to(AppConstant::getAdminEmail())->send(new DeclarationAdmin($period,$user->oav_number,$place,$date_declaration,$name,$phone,$full_path));

                }



                //Send second email

                if( AppConstant::getSecondAdminEmail() ){

                     Mail::to(AppConstant::getSecondAdminEmail())->send(new DeclarationAdmin($period,$user->oav_number,$place,$date_declaration,$name,$phone,$full_path));

                }



                return redirect(route('admin.dec.maList'))->with(['b_a_message' => "E-mail is verzonden"]);

            } else {

                //abort(404);

				return redirect(route('admin.dec.maList'))->with(['b_a_message' => "Geen info te verzenden"]);

            }

        } catch (Exception $e) {

            return redirect(route('admin.dec.maList'))->with(['b_a_message' => "Verzenden e-mail mislukt"]);

        }

    }



    public function createdf($id,$user_id){

        set_time_limit(300);



        $user = User::where("id","=",$user_id)->first();



		/*OLD*/

        $declarationModel = new Declaration();

        $declarationObj = $declarationModel->GetDeclarationById($id);

        $listOfDeclareObject = $declarationModel->getListDeclaration($id);

        // get user_period_id

        $userPeriodModel = new UserPeriod();

        $userPeriodId = $userPeriodModel->getPeriodId($declarationObj->user_period_id);

        $userPeriod = $userPeriodModel->getPeriodData($declarationObj->user_period_id);





		/*NEW

		$user_period_id = $id;

		$userPeriodModel = new UserPeriod();

        $userPeriodId 	= $userPeriodModel->getPeriodId($user_period_id);

        $userPeriod 	= $userPeriodModel->getPeriodData($user_period_id);

		END NEW*/





        $periodObj = Period::where('id', $userPeriodId)->firstOrFail();

        $year = $periodObj->group_period;

        if ($year < 2022) {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('old_sort', '>=', 1)
                ->orderBy('old_sort', 'asc')->get();
        } else {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('sort', '>=', 1)
                ->orderBy('sort', 'asc')->get(); // phmd
        }
        if( $year >= 2025 ){
            //triple isolatieglas, dubbel isolatieglas, 
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->whereIn('id', [14,12,13])
                ->orderBy('sort', 'asc')->get(); // phmd
        }

        $file_name = $userPeriod->file_pdf_name;

        $file_name_data = str_replace(".pdf","",$file_name);

        $current_timestamp = Carbon::now()->timestamp;

        if(strpos($file_name_data,"-") === false){

            $newFilePdf = $file_name_data."-".$current_timestamp.".pdf";

            UserPeriod::where('id', $id)

            ->update([

                'file_pdf_name' => $newFilePdf

            ]);

            $file_name = $newFilePdf;

        }else{

            $array_file_name = explode("-",$file_name_data);

            $file_name_data = $array_file_name[0];

        }



		$listOfDeclareObject_new = [];

		foreach( $listOfDeclareObject as $key => $listOfDeclareVal ){

			$listOfDeclareObject_new[$listOfDeclareVal->type_name] = $listOfDeclareVal;

		}

		$listOfDeclareObject = $listOfDeclareObject_new;



        $data = [

            'user'  => $user,

            'declarationObj'  => $declarationObj,

            'listOfDeclareObject'  => $listOfDeclareObject,

            'periodObj'  => $periodObj,

			'file_name_data' => $file_name_data,

			'userPeriod' => $userPeriod,

            'listType'=> $listType,

            'year'=>$year

        ];





        $pdf = PDF::loadView('dompdf.declaration', $data);

        // get path to save file pdf

        $path = Storage::disk('public')->path("pdf");



        // save file pfd

        $pdf->Output($path.'/'.$file_name, 'F');

        $pdf->save($path.'/'.$file_name);

        $full_path = $path.'/'.$file_name;

        return $pdf->save($path.'/'.$file_name)->download($file_name);

    }



    public function maListNone(){

        $userPeriod = new UserPeriod();

        $list = $userPeriod->getListInvoiceAdmin();

        $listPeriodType = AppConstant::getListPeriodType();

        $text_title = "Aangifte op 0";

        $params = [

            'text_title' => $text_title,

            'list' => $list,

            'listPeriodType' => $listPeriodType

        ];



        return view('admin.declaration.invalid_invoice', $params);

    }

    public function q6List(){

        $userPeriod = new UserPeriod();

        $year = date("Y");

        $list = $userPeriod->getListQ6($year);



        $listPeriodType = AppConstant::getListPeriodType();

        $text_title = "Correcties";

        $params = [

            'text_title' => $text_title,

            'list' => $list,

            'listPeriodType' => $listPeriodType

        ];



        return view('admin.declaration.index', $params);

    }

    public function maDetail($id){
        $userPeriod = new UserPeriod();
        $year = $userPeriod->getYearOfPeriod($id);
        $dec = $userPeriod->getDetailForAdmin($id);
	    if(count($dec) > 0){
            $user = User::where('id', $dec[0]->user_id)->firstOrFail();
            $categoryModel = new Categories();
            $listCategories = $categoryModel->getAllCategories();
			$electronischafval 	= $user->electronischafval;
			$glasafval 			= $user->glasafval;
			foreach( $listCategories as $key => $cat ){
				if( $electronischafval != 1 ){
					if( $cat->title == 'Electronisch afval' ){
						unset( $listCategories[$key] );
					}
				}
				if( $glasafval != 1 ){
					if( $cat->title == 'Glas' ){
						unset( $listCategories[$key] );
					}
				}
			}
            $params = [
                'id' => $id,
                'dec' => $dec,
                'listCategories' => $listCategories,
                'user' => $user,
                'year' => $year,
            ];
            return view('admin.declaration.detail', $params);
        } else {
            abort(404);
        }
    }



    public function aTypeList(){

        $decType = new DeclarationType();

        /* $list = $decType->getList(); */



        // << phmd

        // extend table for sorting

        if (Schema::hasTable('declaration_types')) {

            Schema::table('declaration_types', function ($table) {

                if (!Schema::hasColumn('declaration_types', 'sort')) {

        	        $table->integer('sort')->default(1);

                }

            });

        }

        // >> phmd



        $list = $decType->getListWithCategory();



        $params = [

            'list' => $list

        ];



        return view('admin.declaration.type', $params);

    }



    public function updateDecType($id = 0){

        if(empty($id)){

            $decType = new DeclarationType();

        } else {

            $decType = DeclarationType::where('id', $id)->firstOrFail();

        }



        $categoryModel = new Categories();

        $listCategories = $categoryModel->getAllCategories();



        $params = [

            'decType' => $decType,

            'categories' => $listCategories,

        ];



        return view('admin.declaration.update_type', $params);

    }



    public function deleteDecType($id){

        $dec = DeclarationType::where('id', $id)->firstOrFail();

        $dec->is_deleted = 1;

        $dec->save();



        return redirect(route('admin.dec.aTypeList'))->with(['b_a_message' => "Opgeslagen!"]);

    }



    public function storeDecType(Request $request){

        $data = $request->all();



        $validator = Validator::make($data, [

            'id' => 'required',

            'name' => 'required',

            'unit_price' => 'required|numeric'

        ]);



        if($validator->fails()){

            return redirect(route('admin.dec.updateDecType', ['id' => empty($data['id']) ? 0 : $data['id']]))

                ->withErrors($validator->errors())

                ->withInput();

        } else {

            if(empty($data['id'])){

                $decType = new DeclarationType();

            } else {

                $decType = DeclarationType::where('id', $data['id'])->firstOrFail();

            }

            $decType->name = $data['name'];

            $decType->category_id = $data['category_id'];

            $decType->unit_price = $data['unit_price'];

            $decType->weight = $data['weight'];

            $decType->sort = $data['sort']; // phmd

            $decType->old_sort = $data['old_sort']; // phmd



            if(!empty($data['is_deleted'])){

                $decType->is_deleted = 0;

            }



            $decType->save();



            return redirect(route('admin.dec.aTypeList'))->with(['b_a_message' => "Opgeslagen!"]);

        }

    }



    public function updateDec(Request $request){

        $data = $request->all();

        if(empty($data['period_id'])){

            abort(404);

        }

        $validator = Validator::make($data, [

            'name' => 'required',

            'place' => 'required',

            'phone' => 'required',

            'dec.*.type_id' => 'required',

            'dec.*.status' => 'required'

        ]);



        if(!empty($data['status'])){

            foreach ($data['status'] as $key => $v){

                $validator->sometimes([

                    'dec.' . $key . '.pro_nl',

                    'dec.' . $key . '.imp_be',

                    'dec.' . $key . '.imp_de',

                    'dec.' . $key . '.imp_po',

                    'dec.' . $key . '.imp_turk',

                    'dec.' . $key . '.import'

                ], 'required', function ($input) use ($key){

                    return $input->status[$key] == AppConstant::D_STATUS_ACTIVE;

                });

            }

        }



        if($validator->fails()){

            return redirect(route('admin.dec.maDetail', ['id' => $data['period_id']]))

                ->withErrors($validator->errors())

                ->withInput();

        } else {

            $userPeriod = UserPeriod::where('id', $data['period_id'])->firstOrFail();

            $user = User::where('id', $userPeriod->user_id)->firstOrFail();

            $tax = $user->land == 'NL' ? 21 : 0;

            $check = false;



            foreach ($data['dec'] as $detail){

                $type =  $detail['type_id'];

                $dectype = DeclarationType::where('id', $type)->first();
                if( !isset($year) ){
                    $userPeriod = new UserPeriod();
                    $year = $userPeriod->getYearOfPeriod($data['period_id']);
                }
                if ($year >= 2025 && in_array($type, [12, 14])) {
                    $dectype->unit_price = 0.4;
                }
                $price = !empty($dectype->id) ? $dectype->unit_price : AppConstant::DEFAULT_PRICE;



                if($detail['status'] == AppConstant::D_STATUS_INACTIVE){

                    Declaration::where('user_period_id', $data['period_id'])

                        ->where('type_id', $detail['type_id'])

                        ->update([

                            'status' => $detail['status'],

                            'name' => $data['name'],

                            'place' => $data['place'],

                            'phone' => $data['phone'],

                            'date' => now(),

                            'pro_nl' => null,

                            'imp_be' => null,

                            'imp_de' => null,

                            'imp_po' => null,

                            'imp_turk' => null,

                            'import' => null,

                            'total_m2' => null,

                            'unit_price' => $price,

                            'total' => null,

                            'btw' => null,

                            'total_btw' => null,

                        ]);

                } else {

                    $check = true;

                    $totalM2 = $detail['pro_nl'] + $detail['imp_be'] + $detail['imp_de'] + $detail['imp_po'] + (isset($detail['imp_turk']) ? $detail['imp_turk'] : 0) + $detail['import'];



                    Declaration::where('user_period_id', $data['period_id'])

                        ->where('type_id', $detail['type_id'])

                        ->update([

                            'status' => $detail['status'],

                            'name' => $data['name'],

                            'place' => $data['place'],

                            'phone' => $data['phone'],

                            'date' => now(),

                            'pro_nl' => $detail['pro_nl'],

                            'imp_be' => $detail['imp_be'],

                            'imp_de' => $detail['imp_de'],

                            'imp_po' => $detail['imp_po'],

                            'imp_turk' =>(isset($detail['imp_turk']) ? $detail['imp_turk'] : 0),

                            'import' => $detail['import'],

                            'total_m2' => $totalM2,

                            'unit_price' => $price,

                            'total' => $totalM2 * $price,

                            'btw' => ($totalM2 * $price * $tax) / 100,

                            'total_btw' => ($totalM2 * $price * ($tax + 100)) / 100,

                        ]);

                }

            }



            if($check){

                $userPeriod->status = UserPeriod::STATUS_CREATED;

            } else {

                $userPeriod->status = UserPeriod::STATUS_NONE;

            }



            $userPeriod->admin_updated_at = now();

            $userPeriod->save();

            return redirect(route('admin.dec.maDetail', ['id' => $data['period_id']]))

                ->with(['b_a_message' => "bijgewerkt!"]);

        }

    }



    public function deleteDec(Request $request){

        $id = $request->get('id', 0);

        $dec = UserPeriod::where('id', $id)->first();

        if(!empty($dec->id)){

            //$dec->status = UserPeriod::STATUS_PENDING;

            //$dec->save();

            $dec->delete();

            Declaration::where('user_period_id', $dec->id)->delete();

        }



        return response()->json([

            'status' => 'success'

        ]);

    }

}

