<?php


namespace App\Helper;

use TCPDF;
class MYPDF extends TCPDF
{
    //Page header
    public function Header()
    {
        // full background image
        // store current auto-page-break status
        $bMargin = $this->getBreakMargin();
        $auto_page_break = $this->AutoPageBreak;
        $this->SetAutoPageBreak(false, 0);
         // set background image
        //$img_file = public_path('images/background_vrn.png');
        $img_file_compressor = public_path('images/background_vrn-compressor.png');
        $this->Image($img_file_compressor, 0, 0, 210, 297, '', '', '', false, 300, '', false, false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
    }
    
    // Set footer
    public function Footer() {
        $this->SetFont('helvetica', 'I', 7);
        $this->SetY(-20);
        // Title
        $this->Cell(0, 0, 'Fonds Vlakglas Recycling Nederland - Postbus 340, 2700 AH Zoetermeer - Tel: 088-5678805', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln();
        $this->Cell(0, 0, 'E-mail: info@oavaangifte.nl - BTW nr. 8564.33.779.B.01 - KvK 66188482', 0, 0, 'C');
        $this->Ln();
        // Page number
        $this->Cell(0, 10, 'Bladzijde '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        // Page number
        /* $this->writeHTML($footertext, false, true, false, true);    */
    }  // end of the Footer function
}
