<?php


namespace App\Helper;


class AppConstant
{
    const D_STATUS_INACTIVE = 0;
    const D_STATUS_ACTIVE = 1;

    const NOT_DELETED = 0;
    const IS_DELETED = 1;

    const DEFAULT_PRICE = 0.3;

    const PERIOD_TYPE_QUARTER = 1;
    const PERIOD_TYPE_YEAR = 2;
    //Credit memo
    const PERIOD_TYPE_EDIT = 3;
    const PERIOD_TYPE_MONTH = 4;

    const DEC_TYPE_NULL = 0;

    const MAIL_CREATE_USER = 1;
    const MAIL_CREATE_ADMIN = 2;
    const MAIL_INVOICE = 3;
    const MAIL_CONTACT_ADMIN = 4;
    const MAIL_CREATE_DEC = 5;
    const MAIL_REMIND_PERIOD = 6;
    const MAIL_USER_PASSWORD = 7;
    const MAIL_ADMIN_INVOICE = 8;
    const MAIL_CUSTOMER_INVOICE = 9;

    public static function getAdminEmail()
    {
        return env('ADMIN_EMAIL');
    }

    public static function getSecondAdminEmail()
    {
        return env('ADMIN_SECOND_EMAIL');
    }
    public static function getListPeriodType(){
        return [
            self::PERIOD_TYPE_QUARTER => "kwartaal",
            self::PERIOD_TYPE_MONTH => "maand",
            self::PERIOD_TYPE_YEAR => "jaar",
            self::PERIOD_TYPE_EDIT => "Correctie",
        ];
    }

    public static function getListContactType(){
        return [
            'Algemene vraag',
            'Financiele vraag'
        ];
    }
}
