<?php

namespace App\Console\Commands;

use App\Helper\AppConstant;
use App\Helper\TimeUlti;
use App\Models\Period;
use App\Models\User;
use App\Models\UserPeriod;
use Illuminate\Console\Command;

class CreatePeriod extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'period:create {type}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'create periods';

//    set cron job 0 0 1 */3 * for quarter   (0 0 1 */3 * php path_to_artisan period:create quarter)
//    set cron job 0 0 1 1 * for year (0 0 1 1 * php path_to_artisan period:create year)

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $type = $this->argument('type');

        if (empty($type) || !in_array($type, ['quarter', 'year', 'month', 'months'])) {
            exit('wrong argument.');
        } 

        $period = new Period();

        if ($type == 'year') {
            $start = TimeUlti::firstDayOf('year');
            $end   = TimeUlti::lastDayOf('year');

            $check = Period::where('type', AppConstant::PERIOD_TYPE_YEAR)
                ->whereRaw("DATE_FORMAT(date_start, '%Y-%m-%d') = ?", [$start->format('Y-m-d')])
                ->first();

            if (!empty($check->id)) {
                exit();
            }

            $period->type = AppConstant::PERIOD_TYPE_YEAR;
            $suffix = "Y";

        } elseif ($type == 'quarter') {
            $start = TimeUlti::firstDayOf('quarter');
            $end   = TimeUlti::lastDayOf('quarter');

            $check = Period::where('type', AppConstant::PERIOD_TYPE_QUARTER)
                ->whereRaw("DATE_FORMAT(date_start, '%Y-%m-%d') = ?", [$start->format('Y-m-d')])
                ->first();

            if (!empty($check->id)) {
                exit();
            }

            $period->type = AppConstant::PERIOD_TYPE_QUARTER;
            $suffix = "Q";

        } elseif ($type == 'months') {

            $year = date('Y');

            for ($m = 1; $m <= 12; $m++) {

                $start = \Carbon\Carbon::create($year, $m, 1)->startOfMonth();
                $end   = \Carbon\Carbon::create($year, $m, 1)->endOfMonth();

                $check = Period::where('type', 4)
                    ->whereRaw("DATE_FORMAT(date_start, '%Y-%m-%d') = ?", [$start->format('Y-m-d')])
                    ->first();

                if (!empty($check->id)) {
                    continue;
                }

                $period = new Period();
                $period->type = 4; // maand
                $period->period       = $start->format('Y-m');
                $period->group_period = $start->format('Y');
                $period->description  = "Maand " . $start->format('m-Y');
                $period->date_start   = $start->format('Y-m-d');
                $period->date_end     = $end->format('Y-m-d');
                $period->date_statement = now();
                $period->date_release   = now();
                $period->save();

                $users = User::where('active', User::STATUS_ACTIVE)->get();
                $batch = [];
                $count = 0;

                foreach ($users as $user) {
                    $batch[] = [
                        'user_id'   => $user->id,
                        'period_id' => $period->id
                    ];
                    $count++;

                    if ($count >= 1000) {
                        UserPeriod::insert($batch);
                        $batch = [];
                        $count = 0;
                    }
                }

                if (!empty($batch)) {
                    UserPeriod::insert($batch);
                }
            }

            return;

        } elseif ($type == 'month') {
            $start = TimeUlti::firstDayOf('month');
            $end   = TimeUlti::lastDayOf('month');

            // type 4 = maand
            $check = Period::where('type', 4)
                ->whereRaw("DATE_FORMAT(date_start, '%Y-%m-%d') = ?", [$start->format('Y-m-d')])
                ->first();

            if (!empty($check->id)) {
                exit();
            }

            $period->type = 4; // maand

            $period->period       = $start->format('Y-m');
            $period->group_period = $start->format('Y');
            $period->description  = "Maand " . $start->format('m-Y');
            $period->date_start   = $start->format('Y-m-d');
            $period->date_end     = $end->format('Y-m-d');
            $period->date_statement = now();
            $period->date_release   = now();

            $period->save();

            // assign to all active users`
            $users = User::where('active', User::STATUS_ACTIVE)->get();
            $batch = [];
            $count = 0;

            foreach ($users as $user) {
                $batch[] = [
                    'user_id'   => $user->id,
                    'period_id' => $period->id
                ];
                $count++;

                if ($count >= 1000) {
                    UserPeriod::insert($batch);
                    $batch = [];
                    $count = 0;
                }
            }

            if (!empty($batch)) {
                UserPeriod::insert($batch);
            }

            return;
        }

        if ($type == 'year' || $type == 'quarter') {
            $period->period = $start->format('Ym') . $suffix;
            $period->group_period = $start->format('Y');
            $period->description = $start->format('d-m-Y') . ' tot ' . $end->format('d-m-Y');
            $period->date_start = $start->format('Y-m-d');
            $period->date_end = $end->format('Y-m-d');
            $period->date_statement = now();
            $period->date_release = now();

            $period->save();

            $users = User::where('active', User::STATUS_ACTIVE)->get();
            $count = 0;
            $insert = [];
            foreach ($users as $user){
                $count++;
                $insert[] = [
                    'user_id' => $user->id,
                    'period_id' => $period->id
                ];
                if($count > 1000){
                    $count = 0;
                    UserPeriod::insert($insert);
                    $insert = [];
                }
            }

            if(!empty($insert)){
                UserPeriod::insert($insert);
            }
        }
    }
}
